/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.hammer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import se.mickelus.tetra.blocks.forged.hammer.HammerBaseBlockEntity;
import se.mickelus.tetra.blocks.forged.hammer.HammerEffect;

@ParametersAreNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
public class HammerBaseRenderer
implements BlockEntityRenderer<HammerBaseBlockEntity> {
    public static final Material material = new Material(TextureAtlas.f_118259_, new ResourceLocation("tetra", "blocks/forged_hammer/base_sheet"));
    public static ModelLayerLocation layer = new ModelLayerLocation(new ResourceLocation("tetra", "hammer_base"), "main");
    private final ModelPart unpowered;
    private final ModelPart powered;
    private final ModelPart[] modulesA;
    private final ModelPart[] modulesB;
    private final ModelPart cellAunpowered;
    private final ModelPart cellBunpowered;
    private final ModelPart cellApowered;
    private final ModelPart cellBpowered;

    public HammerBaseRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart modelpart = context.m_173582_(layer);
        this.unpowered = modelpart.m_171324_("unpowered");
        this.powered = modelpart.m_171324_("powered");
        HammerEffect[] effects = HammerEffect.values();
        this.modulesA = new ModelPart[effects.length];
        this.modulesB = new ModelPart[effects.length];
        for (int i = 0; i < effects.length; ++i) {
            this.modulesA[i] = modelpart.m_171324_("moduleA" + i);
            this.modulesB[i] = modelpart.m_171324_("moduleB" + i);
        }
        this.cellAunpowered = modelpart.m_171324_("cellAunpowered");
        this.cellBunpowered = modelpart.m_171324_("cellBunpowered");
        this.cellApowered = modelpart.m_171324_("cellApowered");
        this.cellBpowered = modelpart.m_171324_("cellBpowered");
    }

    public static LayerDefinition createLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition parts = mesh.m_171576_();
        parts.m_171599_("unpowered", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f), PartPose.f_171404_);
        parts.m_171599_("powered", CubeListBuilder.m_171558_().m_171514_(64, 0).m_171481_(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f), PartPose.f_171404_);
        HammerEffect[] effects = HammerEffect.values();
        for (int i = 0; i < effects.length; ++i) {
            parts.m_171599_("moduleA" + i, CubeListBuilder.m_171558_().m_171514_(i * 16, 32).m_171488_(0.0f, 0.0f, -16.0f, 16.0f, 16.0f, 0.0f, new CubeDeformation(0.03f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5707964f, (float)0.0f));
            parts.m_171599_("moduleB" + i, CubeListBuilder.m_171558_().m_171514_(i * 16, 32).m_171488_(-16.0f, 0.0f, 0.0f, 16.0f, 16.0f, 0.0f, new CubeDeformation(0.03f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.5707964f, (float)0.0f));
        }
        parts.m_171599_("cellAunpowered", CubeListBuilder.m_171558_().m_171514_(48, 0).m_171481_(5.5f, -19.0f, 5.5f, 5.0f, 3.0f, 5.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5707964f, (float)0.0f, (float)0.0f));
        parts.m_171599_("cellApowered", CubeListBuilder.m_171558_().m_171514_(48, 8).m_171481_(5.5f, -19.0f, 5.5f, 5.0f, 3.0f, 5.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5707964f, (float)0.0f, (float)0.0f));
        parts.m_171599_("cellBunpowered", CubeListBuilder.m_171558_().m_171514_(48, 0).m_171481_(5.5f, -3.0f, -10.5f, 5.0f, 3.0f, 5.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        parts.m_171599_("cellBpowered", CubeListBuilder.m_171558_().m_171514_(48, 8).m_171481_(5.5f, -3.0f, -10.5f, 5.0f, 3.0f, 5.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)128, (int)64);
    }

    public void render(HammerBaseBlockEntity tile, float v, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (tile.m_58898_()) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.5, 0.5, 0.5);
            matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(tile.getFacing().m_122435_()));
            matrixStack.m_85837_(-0.5, -0.5, -0.5);
            VertexConsumer vertexBuilder = material.m_119194_(buffer, RenderType::m_110452_);
            if (tile.isFunctional()) {
                this.powered.m_104301_(matrixStack, vertexBuilder, combinedLight, combinedOverlay);
            } else {
                this.unpowered.m_104301_(matrixStack, vertexBuilder, combinedLight, combinedOverlay);
            }
            if (tile.hasCellInSlot(0)) {
                if (tile.getCellFuel(0) > 0) {
                    this.cellApowered.m_104301_(matrixStack, vertexBuilder, combinedLight, combinedOverlay);
                } else {
                    this.cellAunpowered.m_104301_(matrixStack, vertexBuilder, combinedLight, combinedOverlay);
                }
            }
            if (tile.hasCellInSlot(1)) {
                if (tile.getCellFuel(1) > 0) {
                    this.cellBpowered.m_104301_(matrixStack, vertexBuilder, combinedLight, combinedOverlay);
                } else {
                    this.cellBunpowered.m_104301_(matrixStack, vertexBuilder, combinedLight, combinedOverlay);
                }
            }
            if (tile.getEffect(true) != null) {
                this.modulesA[tile.getEffect(true).ordinal()].m_104301_(matrixStack, vertexBuilder, combinedLight, combinedOverlay);
            }
            if (tile.getEffect(false) != null) {
                this.modulesB[tile.getEffect(false).ordinal()].m_104301_(matrixStack, vertexBuilder, combinedLight, combinedOverlay);
            }
            matrixStack.m_85849_();
        }
    }
}

