/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.storageracks.network;

import com.ldtteam.storageracks.inv.CombinedItemHandler;
import com.ldtteam.storageracks.network.IMessage;
import com.ldtteam.storageracks.tileentities.AbstractTileEntityRack;
import com.ldtteam.storageracks.tileentities.TileEntityController;
import com.ldtteam.storageracks.utils.SortingUtils;
import com.ldtteam.storageracks.utils.SoundUtils;
import com.ldtteam.storageracks.utils.WorldUtil;
import java.util.LinkedHashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class SortControllerMessage
implements IMessage {
    private BlockPos controllerPos;

    public SortControllerMessage() {
    }

    public SortControllerMessage(BlockPos pos) {
        this.controllerPos = pos;
    }

    @Override
    public void toBytes(FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130064_(this.controllerPos);
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        this.controllerPos = buf.m_130135_();
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context context, boolean b) {
        Level world = context.getSender().m_20193_();
        BlockEntity tileEntity = world.m_7702_(this.controllerPos);
        if (tileEntity instanceof TileEntityController && ((TileEntityController)tileEntity).isSortUnlocked()) {
            LinkedHashSet<IItemHandlerModifiable> handlers = new LinkedHashSet<IItemHandlerModifiable>();
            for (BlockPos pos : ((TileEntityController)tileEntity).racks) {
                BlockEntity te;
                if (!WorldUtil.isBlockLoaded((LevelAccessor)world, pos) || !((te = world.m_7702_(pos)) instanceof AbstractTileEntityRack)) continue;
                handlers.add((IItemHandlerModifiable)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).resolve().get());
            }
            SortingUtils.sort(new CombinedItemHandler("controller", handlers.toArray(new IItemHandlerModifiable[0])));
            SoundUtils.playSuccessSound((Player)context.getSender(), this.controllerPos);
        }
    }
}

