/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.storageracks.datagen;

import com.google.gson.JsonElement;
import com.ldtteam.datagenerators.loot_table.LootTableJson;
import com.ldtteam.datagenerators.loot_table.LootTableTypeEnum;
import com.ldtteam.datagenerators.loot_table.pool.PoolJson;
import com.ldtteam.datagenerators.loot_table.pool.conditions.survives_explosion.SurvivesExplosionConditionJson;
import com.ldtteam.datagenerators.loot_table.pool.entry.EntryJson;
import com.ldtteam.datagenerators.loot_table.pool.entry.EntryTypeEnum;
import com.ldtteam.storageracks.blocks.CornerBlock;
import com.ldtteam.storageracks.blocks.ModBlocks;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class DefaultBlockLootTableProvider
implements DataProvider {
    private final DataGenerator generator;

    public DefaultBlockLootTableProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void m_213708_(@NotNull CachedOutput cache) throws IOException {
        for (RegistryObject<CornerBlock> registryObject : ModBlocks.corners) {
            this.saveBlock((Block)registryObject.get(), cache);
        }
        for (RegistryObject registryObject : ModBlocks.racks) {
            this.saveBlock((Block)registryObject.get(), cache);
        }
        this.saveBlock((Block)ModBlocks.diamondController.get(), cache);
        this.saveBlock((Block)ModBlocks.emeraldController.get(), cache);
        this.saveBlock((Block)ModBlocks.goldController.get(), cache);
        this.saveBlock((Block)ModBlocks.ironController.get(), cache);
        this.saveBlock((Block)ModBlocks.stoneController.get(), cache);
    }

    private void saveBlock(Block block, CachedOutput cache) throws IOException {
        EntryJson entryJson = new EntryJson();
        entryJson.setType(EntryTypeEnum.ITEM);
        entryJson.setName(ForgeRegistries.BLOCKS.getKey((Object)block).toString());
        PoolJson poolJson = new PoolJson();
        poolJson.setEntries(Collections.singletonList(entryJson));
        poolJson.setRolls(1);
        poolJson.setConditions(Collections.singletonList(new SurvivesExplosionConditionJson()));
        LootTableJson lootTableJson = new LootTableJson();
        lootTableJson.setType(LootTableTypeEnum.BLOCK);
        lootTableJson.setPools(Collections.singletonList(poolJson));
        Path savePath = this.generator.m_123916_().resolve("data/storageracks/loot_tables/blocks").resolve(ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_() + ".json");
        DataProvider.m_236072_((CachedOutput)cache, (JsonElement)lootTableJson.serialize(), (Path)savePath);
    }

    @NotNull
    public String m_6055_() {
        return "Default Block Loot Tables Provider";
    }
}

