/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.storageracks.datagen;

import com.google.gson.JsonElement;
import com.ldtteam.datagenerators.blockstate.BlockstateJson;
import com.ldtteam.datagenerators.blockstate.BlockstateModelJson;
import com.ldtteam.datagenerators.blockstate.BlockstateVariantJson;
import com.ldtteam.storageracks.blocks.CornerBlock;
import com.ldtteam.storageracks.blocks.ModBlocks;
import com.ldtteam.storageracks.blocks.RackType;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class BlockStateProvider
implements DataProvider {
    private final DataGenerator generator;

    public BlockStateProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void m_213708_(@NotNull CachedOutput cache) throws IOException {
        Path blockstatePath;
        Path blockstateFolder;
        BlockstateJson blockstate;
        HashMap<Object, BlockstateVariantJson> variants;
        for (RegistryObject<CornerBlock> registryObject : ModBlocks.corners) {
            variants = new HashMap<Object, BlockstateVariantJson>();
            variants.put("", new BlockstateVariantJson(new BlockstateModelJson("storageracks:block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)registryObject.get())).m_135815_())));
            blockstate = new BlockstateJson(variants);
            blockstateFolder = this.generator.m_123916_().resolve("assets/storageracks/blockstates/");
            blockstatePath = blockstateFolder.resolve(ForgeRegistries.BLOCKS.getKey((Object)((Block)registryObject.get())).m_135815_() + ".json");
            DataProvider.m_236072_((CachedOutput)cache, (JsonElement)blockstate.serialize(), (Path)blockstatePath);
        }
        for (RegistryObject registryObject : ModBlocks.racks) {
            variants = new HashMap();
            for (RackType type : RackType.values()) {
                variants.put("variant=" + type.getName(), new BlockstateVariantJson(new BlockstateModelJson("storageracks:block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)registryObject.get())).m_135815_() + type.getName())));
            }
            blockstate = new BlockstateJson(variants);
            blockstateFolder = this.generator.m_123916_().resolve("assets/storageracks/blockstates/");
            blockstatePath = blockstateFolder.resolve(ForgeRegistries.BLOCKS.getKey((Object)((Block)registryObject.get())).m_135815_() + ".json");
            DataProvider.m_236072_((CachedOutput)cache, (JsonElement)blockstate.serialize(), (Path)blockstatePath);
        }
    }

    @NotNull
    public String m_6055_() {
        return "Brick BlockStates Provider";
    }
}

