/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.storageracks.blocks;

import com.ldtteam.storageracks.ModCreativeTabs;
import com.ldtteam.storageracks.blocks.ControllerBlock;
import com.ldtteam.storageracks.blocks.CornerBlock;
import com.ldtteam.storageracks.blocks.FrameType;
import com.ldtteam.storageracks.blocks.RackBlock;
import com.ldtteam.storageracks.blocks.WoodType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public final class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS;
    public static final DeferredRegister<Item> ITEMS;
    public static List<RegistryObject<RackBlock>> racks;
    public static List<RegistryObject<CornerBlock>> corners;
    public static RegistryObject<ControllerBlock> stoneController;
    public static RegistryObject<ControllerBlock> ironController;
    public static RegistryObject<ControllerBlock> goldController;
    public static RegistryObject<ControllerBlock> emeraldController;
    public static RegistryObject<ControllerBlock> diamondController;

    public static <B extends Block, I extends Item> RegistryObject<B> register(String name, Supplier<B> block, Function<B, I> item) {
        RegistryObject registered = BLOCKS.register(name.toLowerCase(), block);
        ITEMS.register(name.toLowerCase(), () -> (Item)item.apply((Block)registered.get()));
        return registered;
    }

    private ModBlocks() {
    }

    static {
        ArrayList<Object> list;
        BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"storageracks");
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"storageracks");
        racks = new ArrayList<RegistryObject<RackBlock>>();
        corners = new ArrayList<RegistryObject<CornerBlock>>();
        stoneController = ModBlocks.register("stone_controller", () -> new ControllerBlock(Items.f_41922_, Items.f_41913_, 1), b -> new BlockItem((Block)b, new Item.Properties().m_41491_(ModCreativeTabs.STORAGERACKS)));
        ironController = ModBlocks.register("iron_controller", () -> new ControllerBlock(Items.f_42416_, Items.f_41912_, 2), b -> new BlockItem((Block)b, new Item.Properties().m_41491_(ModCreativeTabs.STORAGERACKS)));
        goldController = ModBlocks.register("gold_controller", () -> new ControllerBlock(Items.f_42417_, Items.f_42110_, 3), b -> new BlockItem((Block)b, new Item.Properties().m_41491_(ModCreativeTabs.STORAGERACKS)));
        emeraldController = ModBlocks.register("emerald_controller", () -> new ControllerBlock(Items.f_42616_, Items.f_41959_, 4), b -> new BlockItem((Block)b, new Item.Properties().m_41491_(ModCreativeTabs.STORAGERACKS)));
        diamondController = ModBlocks.register("diamond_controller", () -> new ControllerBlock(Items.f_42415_, null, 5), b -> new BlockItem((Block)b, new Item.Properties().m_41491_(ModCreativeTabs.STORAGERACKS)));
        for (WoodType woodType : WoodType.values()) {
            list = new ArrayList<Object>();
            for (FrameType frame : FrameType.values()) {
                list.add(ModBlocks.register(woodType.m_7912_() + "_" + frame.m_7912_() + "_rack", () -> new RackBlock(woodType, frame, frame.getUpgradeCost()), b -> new BlockItem((Block)b, new Item.Properties().m_41491_(ModCreativeTabs.STORAGERACKS))));
            }
            racks.addAll(list);
        }
        for (WoodType woodType : WoodType.values()) {
            list = new ArrayList();
            for (FrameType frame : FrameType.values()) {
                list.add(ModBlocks.register(woodType.m_7912_() + "_" + frame.m_7912_() + "_corner", () -> new CornerBlock(woodType, frame), b -> new BlockItem((Block)b, new Item.Properties().m_41491_(ModCreativeTabs.STORAGERACKS))));
            }
            corners.addAll(list);
        }
    }
}

