/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.sootychimneys.recipe.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ChanceResult {
    public static final Codec<ChanceResult> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Registry.f_122827_.m_194605_().fieldOf("item").forGetter(chanceResult -> chanceResult.stack.m_41720_()), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(chanceResult -> chanceResult.stack.m_41613_()), (App)CompoundTag.f_128325_.optionalFieldOf("tag").forGetter(chanceResult -> Optional.ofNullable(chanceResult.stack.m_41783_())), (App)Codec.FLOAT.optionalFieldOf("chance", (Object)Float.valueOf(1.0f)).forGetter(ChanceResult::getChance)).apply((Applicative)instance, (item, count, compoundTag, chance) -> {
        ItemStack stack = new ItemStack((ItemLike)item, count.intValue());
        compoundTag.ifPresent(tag -> stack.m_41751_(tag));
        return new ChanceResult(stack, chance.floatValue());
    }));
    public static final ChanceResult EMPTY = new ChanceResult(ItemStack.f_41583_, 1.0f);
    private final ItemStack stack;
    private final float chance;

    public ChanceResult(ItemStack stack, float chance) {
        this.stack = stack;
        if (chance == 0.0f || Float.isNaN(chance)) {
            throw new IllegalArgumentException("Chance cannot be 0 or NaN.\n" + this.toJson().toString());
        }
        this.chance = chance;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public float getChance() {
        return this.chance;
    }

    public ItemStack rollOutput(Random rand) {
        int outputAmount = this.stack.m_41613_();
        for (int roll = 0; roll < this.stack.m_41613_(); ++roll) {
            if (!(rand.nextFloat() > this.chance)) continue;
            --outputAmount;
        }
        if (outputAmount == 0) {
            return ItemStack.f_41583_;
        }
        ItemStack out = this.stack.m_41777_();
        out.m_41764_(outputAmount);
        return out;
    }

    public JsonElement toJson() {
        return (JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).getOrThrow(false, error -> {
            throw new IllegalStateException((String)error);
        });
    }

    public static ChanceResult fromJson(JsonElement jsonElement) {
        if (!jsonElement.isJsonObject()) {
            throw new JsonSyntaxException("Must be a json object");
        }
        return (ChanceResult)((Pair)CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).getOrThrow(false, error -> {
            throw new IllegalStateException((String)error);
        })).getFirst();
    }

    public void toBuffer(FriendlyByteBuf buf) {
        buf.m_130055_(this.getStack());
        buf.writeFloat(this.getChance());
    }

    public static ChanceResult fromBuffer(FriendlyByteBuf buf) {
        return new ChanceResult(buf.m_130267_(), buf.readFloat());
    }
}

