/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.sootychimneys.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.github.mortuusars.sootychimneys.recipe.ingredient.ChanceResult;
import io.github.mortuusars.sootychimneys.setup.ModRecipeSerializers;
import io.github.mortuusars.sootychimneys.setup.ModRecipeTypes;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SootScrapingRecipe
implements Recipe<RecipeWrapper> {
    public static final int MAX_RESULTS = 4;
    private final ResourceLocation id;
    private final String group;
    private final Ingredient input;
    private final Ingredient tool;
    private final NonNullList<ChanceResult> results;

    public SootScrapingRecipe(ResourceLocation id, String group, Ingredient input, Ingredient tool, NonNullList<ChanceResult> results) {
        this.id = id;
        this.group = group;
        this.input = input;
        this.tool = tool;
        this.results = results;
    }

    public boolean m_5598_() {
        return true;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public String m_6076_() {
        return this.group;
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        NonNullList nonnulllist = NonNullList.m_122779_();
        nonnulllist.add((Object)this.input);
        return nonnulllist;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public Ingredient getTool() {
        return this.tool;
    }

    public boolean matches(RecipeWrapper container, @NotNull Level pLevel) {
        if (container.m_7983_()) {
            return false;
        }
        return this.input.test(container.m_8020_(0));
    }

    @NotNull
    public ItemStack assemble(@NotNull RecipeWrapper inv) {
        return ((ChanceResult)this.results.get(0)).getStack().m_41777_();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return false;
    }

    public ItemStack m_8043_() {
        return ((ChanceResult)this.results.get(0)).getStack();
    }

    protected int getMaxInputCount() {
        return 1;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.SOOT_SCRAPING.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.SOOT_SCRAPING.get();
    }

    public static class Serializer
    implements RecipeSerializer<SootScrapingRecipe> {
        @NotNull
        public SootScrapingRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)json.getAsJsonObject("ingredient"));
            JsonObject toolObject = GsonHelper.m_13930_((JsonObject)json, (String)"tool");
            Ingredient tool = Ingredient.m_43917_((JsonElement)toolObject);
            if (ingredient.m_43947_()) {
                throw new JsonParseException("No ingredients for soot scraping recipe");
            }
            if (tool.m_43947_()) {
                throw new JsonParseException("No tool for soot scraping recipe");
            }
            NonNullList results = NonNullList.m_122779_();
            JsonArray resultsJsonArray = GsonHelper.m_13933_((JsonObject)json, (String)"results");
            for (JsonElement result : resultsJsonArray) {
                results.add((Object)ChanceResult.fromJson(result));
            }
            if (results.size() > 4) {
                throw new JsonParseException("Too many results for soot scraping recipe! The maximum quantity of unique results is 4");
            }
            return new SootScrapingRecipe(recipeId, group, ingredient, tool, (NonNullList<ChanceResult>)results);
        }

        public void toNetwork(FriendlyByteBuf buffer, SootScrapingRecipe recipe) {
            buffer.m_130070_(recipe.group);
            recipe.input.m_43923_(buffer);
            recipe.tool.m_43923_(buffer);
            buffer.m_130130_(recipe.results.size());
            for (ChanceResult result : recipe.results) {
                result.toBuffer(buffer);
            }
        }

        @Nullable
        public SootScrapingRecipe fromNetwork(@NotNull ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String group = buffer.m_130277_();
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient tool = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int resultsCount = buffer.m_130242_();
            NonNullList results = NonNullList.m_122780_((int)resultsCount, (Object)ChanceResult.EMPTY);
            for (int i = 0; i < results.size(); ++i) {
                results.set(i, (Object)ChanceResult.fromBuffer(buffer));
            }
            return new SootScrapingRecipe(recipeId, group, input, tool, (NonNullList<ChanceResult>)results);
        }
    }
}

