/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.sootychimneys.integration.jei;

import com.google.common.collect.ImmutableList;
import io.github.mortuusars.sootychimneys.SootyChimneys;
import io.github.mortuusars.sootychimneys.config.CommonConfig;
import io.github.mortuusars.sootychimneys.integration.jei.JeiRecipeTypes;
import io.github.mortuusars.sootychimneys.integration.jei.category.SootCoveringRecipeCategory;
import io.github.mortuusars.sootychimneys.integration.jei.category.SootScrapingRecipeCategory;
import io.github.mortuusars.sootychimneys.integration.jei.recipe.SootCoveringJeiRecipe;
import io.github.mortuusars.sootychimneys.integration.jei.recipe.SootScrapingJeiRecipe;
import io.github.mortuusars.sootychimneys.setup.ModItems;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

@JeiPlugin
public class SootyChimneysJeiPlugin
implements IModPlugin {
    private static final ResourceLocation UID = SootyChimneys.resource("jei_plugin");

    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        if (((Boolean)CommonConfig.ADD_SOOT_COVERING_TO_JEI.get()).booleanValue() && (Double)CommonConfig.DIRTY_CHANCE.get() > 0.0) {
            registration.addRecipeCategories(new IRecipeCategory[]{new SootCoveringRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        }
        if (((Boolean)CommonConfig.ADD_SOOT_SCRAPING_TO_JEI.get()).booleanValue()) {
            registration.addRecipeCategories(new IRecipeCategory[]{new SootScrapingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        }
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(JeiRecipeTypes.SOOT_COVERING, (List)ImmutableList.of((Object)new SootCoveringJeiRecipe((Item)ModItems.BRICK_CHIMNEY.get(), (Item)ModItems.DIRTY_BRICK_CHIMNEY.get()), (Object)new SootCoveringJeiRecipe((Item)ModItems.STONE_BRICK_CHIMNEY.get(), (Item)ModItems.DIRTY_STONE_BRICK_CHIMNEY.get()), (Object)new SootCoveringJeiRecipe((Item)ModItems.TERRACOTTA_CHIMNEY.get(), (Item)ModItems.DIRTY_TERRACOTTA_CHIMNEY.get()), (Object)new SootCoveringJeiRecipe((Item)ModItems.COPPER_CHIMNEY.get(), (Item)ModItems.DIRTY_COPPER_CHIMNEY.get())));
        registration.addRecipes(JeiRecipeTypes.SOOT_SCRAPING, (List)ImmutableList.of((Object)new SootScrapingJeiRecipe((Item)ModItems.DIRTY_BRICK_CHIMNEY.get(), (Item)ModItems.BRICK_CHIMNEY.get()), (Object)new SootScrapingJeiRecipe((Item)ModItems.DIRTY_STONE_BRICK_CHIMNEY.get(), (Item)ModItems.STONE_BRICK_CHIMNEY.get()), (Object)new SootScrapingJeiRecipe((Item)ModItems.DIRTY_TERRACOTTA_CHIMNEY.get(), (Item)ModItems.TERRACOTTA_CHIMNEY.get()), (Object)new SootScrapingJeiRecipe((Item)ModItems.DIRTY_COPPER_CHIMNEY.get(), (Item)ModItems.COPPER_CHIMNEY.get())));
    }
}

