/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.sootychimneys.data;

import io.github.mortuusars.sootychimneys.setup.ModBlocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;

public class ModLanguageProvider
extends LanguageProvider {
    private final String _locale;

    public ModLanguageProvider(DataGenerator gen, String locale) {
        super(gen, "sootychimneys", locale);
        this._locale = locale;
    }

    protected void addTranslations() {
        switch (this._locale) {
            case "en_us": {
                this.genEN_US();
                break;
            }
            case "uk_ua": {
                this.genUK_UA();
                break;
            }
            default: {
                throw new IllegalArgumentException("This locale is not supported for generation.");
            }
        }
    }

    private void genEN_US() {
        this.add((Block)ModBlocks.BRICK_CHIMNEY.get(), "Brick Chimney");
        this.add((Block)ModBlocks.DIRTY_BRICK_CHIMNEY.get(), "Dirty Brick Chimney");
        this.add((Block)ModBlocks.STONE_BRICK_CHIMNEY.get(), "Stone Brick Chimney");
        this.add((Block)ModBlocks.DIRTY_STONE_BRICK_CHIMNEY.get(), "Dirty Stone Brick Chimney");
        this.add((Block)ModBlocks.TERRACOTTA_CHIMNEY.get(), "Terracotta Chimney");
        this.add((Block)ModBlocks.DIRTY_TERRACOTTA_CHIMNEY.get(), "Dirty Terracotta Chimney");
        this.add((Block)ModBlocks.COPPER_CHIMNEY.get(), "Copper Chimney");
        this.add((Block)ModBlocks.DIRTY_COPPER_CHIMNEY.get(), "Dirty Copper Chimney");
        this.add("message.sootychimneys.blocked", "Smoke blocked");
        this.add("message.sootychimneys.open", "Smoke flow restored");
        this.add("jei.sootychimneys.category.soot_covering", "Soot Covering");
        this.add("jei.sootychimneys.category.soot_scraping", "Soot Scraping");
        this.add("jei.sootychimneys.category.soot_scraping.soot_items_info", "May produce a byproduct");
    }

    private void genUK_UA() {
        this.add((Block)ModBlocks.BRICK_CHIMNEY.get(), "\u0426\u0435\u0433\u043b\u044f\u043d\u0438\u0439 \u0414\u0438\u043c\u043e\u0445\u0456\u0434");
        this.add((Block)ModBlocks.DIRTY_BRICK_CHIMNEY.get(), "\u0411\u0440\u0443\u0434\u043d\u0438\u0439 \u0426\u0435\u0433\u043b\u044f\u043d\u0438\u0439 \u0414\u0438\u043c\u043e\u0445\u0456\u0434");
        this.add((Block)ModBlocks.STONE_BRICK_CHIMNEY.get(), "\u0414\u0438\u043c\u043e\u0445\u0456\u0434 \u0437 \u041a\u0430\u043c'\u044f\u043d\u043e\u0457 \u0426\u0435\u0433\u043b\u0438");
        this.add((Block)ModBlocks.DIRTY_STONE_BRICK_CHIMNEY.get(), "\u0411\u0440\u0443\u0434\u043d\u0438\u0439 \u0414\u0438\u043c\u043e\u0445\u0456\u0434 \u0437 \u041a\u0430\u043c'\u044f\u043d\u043e\u0457 \u0426\u0435\u0433\u043b\u0438");
        this.add((Block)ModBlocks.TERRACOTTA_CHIMNEY.get(), "\u0422\u0435\u0440\u0430\u043a\u043e\u0442\u043e\u0432\u0438\u0439 \u0414\u0438\u043c\u043e\u0445\u0456\u0434");
        this.add((Block)ModBlocks.DIRTY_TERRACOTTA_CHIMNEY.get(), "\u0411\u0440\u0443\u0434\u043d\u0438\u0439 \u0422\u0435\u0440\u0430\u043a\u043e\u0442\u043e\u0432\u0438\u0439 \u0414\u0438\u043c\u043e\u0445\u0456\u0434");
        this.add((Block)ModBlocks.COPPER_CHIMNEY.get(), "\u041c\u0456\u0434\u043d\u0438\u0439 \u0414\u0438\u043c\u043e\u0445\u0456\u0434");
        this.add((Block)ModBlocks.DIRTY_COPPER_CHIMNEY.get(), "\u0411\u0440\u0443\u0434\u043d\u0438\u0439 \u041c\u0456\u0434\u043d\u0438\u0439 \u0414\u0438\u043c\u043e\u0445\u0456\u0434");
        this.add("message.sootychimneys.blocked", "\u0412\u0438\u0445\u0456\u0434 \u0434\u0438\u043c\u0443 \u043f\u0435\u0440\u0435\u043a\u0440\u0438\u0442\u043e");
        this.add("message.sootychimneys.open", "\u0412\u0438\u0445\u0456\u0434 \u0434\u0438\u043c\u0443 \u0432\u0456\u0434\u043d\u043e\u0432\u043b\u0435\u043d\u043e");
        this.add("jei.sootychimneys.category.soot_covering", "\u0417\u0430\u0431\u0440\u0443\u0434\u043d\u0435\u043d\u043d\u044f \u0421\u0430\u0436\u0435\u044e");
        this.add("jei.sootychimneys.category.soot_scraping", "\u0417\u0456\u0448\u043a\u0440\u0456\u0431 \u0421\u0430\u0436\u0456");
        this.add("jei.sootychimneys.category.soot_scraping.soot_items_info", "\u041c\u043e\u0436\u0435 \u043c\u0430\u0442\u0438 \u0434\u043e\u0434\u0430\u0442\u043a\u043e\u0432\u0438\u0439 \u043f\u0440\u043e\u0434\u0443\u043a\u0442");
    }
}

