/*
 * Decompiled with CFR 0.152.
 */
package fonnymunkey.simplehats.common.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import fonnymunkey.simplehats.common.entity.HatDisplay;
import fonnymunkey.simplehats.common.init.ModConfig;
import fonnymunkey.simplehats.common.init.ModRegistry;
import fonnymunkey.simplehats.util.HatEntry;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class HatItem
extends Item
implements ICurioItem,
ICurioRenderer {
    private HatEntry hatEntry;
    private BakedModel hatModel;

    public HatItem(HatEntry entry) {
        super(new Item.Properties().m_41487_(1).m_41491_(ModRegistry.HAT_TAB).m_41497_(entry.getHatRarity()).m_41486_());
        this.hatEntry = entry;
    }

    public HatEntry getHatEntry() {
        return this.hatEntry;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack itemStack, Level level, List<Component> tooltip, TooltipFlag flag) {
        if (((HatItem)itemStack.m_41720_()).getHatEntry().getHatVariantRange() > 0) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.simplehats.variant"));
        }
        if (((HatItem)itemStack.m_41720_()).getHatEntry().getHatName().equalsIgnoreCase("special")) {
            if (itemStack.m_41783_() != null && itemStack.m_41783_().m_128451_("CustomModelData") > 0) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.simplehats.special_true"));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.simplehats.special_false"));
            }
        }
    }

    @Nullable
    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return (Boolean)ModConfig.COMMON.allowHatInHelmetSlot.get() != false ? EquipmentSlot.HEAD : null;
    }

    public ICurio.DropRule getDropRule(SlotContext slotContext, DamageSource source, int lootingLevel, boolean recentlyHit, ItemStack stack) {
        if (slotContext.entity() instanceof Player && ((Boolean)ModConfig.COMMON.keepHatOnDeath.get()).booleanValue()) {
            return ICurio.DropRule.ALWAYS_KEEP;
        }
        return defaultInstance.getDropRule(slotContext, source, lootingLevel, recentlyHit);
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        HatEntry.HatParticleSettings particleSettings;
        ItemRenderer renderer = Minecraft.m_91087_().m_91291_();
        if (slotContext.entity() == Minecraft.m_91087_().f_91075_ && Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON && ((Boolean)ModConfig.CLIENT.forceFirstPersonNoRender.get()).booleanValue()) {
            return;
        }
        if (!slotContext.entity().m_20145_()) {
            matrixStack.m_85836_();
            if (slotContext.entity() instanceof HatDisplay) {
                matrixStack.m_85837_(0.0, 0.97, 0.0);
            } else {
                HatItem.translateToHead(matrixStack, renderLayerParent, slotContext.entity(), netHeadYaw, headPitch);
                if (slotContext.entity().m_6047_()) {
                    matrixStack.m_85837_(0.0, 0.0, (double)0.015f);
                }
            }
            matrixStack.m_85841_(0.66f, 0.66f, 0.66f);
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
            if (this.hatModel == null) {
                this.hatModel = renderer.m_115103_().m_109393_().m_119422_(new ModelResourceLocation("simplehats:" + this.hatEntry.getHatName() + "#inventory"));
            }
            if (stack.m_41783_() != null && stack.m_41783_().m_128451_("CustomModelData") != 0) {
                renderer.m_115143_(stack, ItemTransforms.TransformType.HEAD, false, matrixStack, renderTypeBuffer, light, OverlayTexture.f_118083_, Objects.requireNonNullElse(this.hatModel.m_7343_().m_173464_(this.hatModel, stack, (ClientLevel)slotContext.entity().f_19853_, slotContext.entity(), 0), this.hatModel));
            } else {
                renderer.m_115143_(stack, ItemTransforms.TransformType.HEAD, false, matrixStack, renderTypeBuffer, light, OverlayTexture.f_118083_, this.hatModel);
            }
            matrixStack.m_85849_();
        }
        if (slotContext.entity() instanceof Player && (particleSettings = this.hatEntry.getHatParticleSettings()).getUseParticles() && !Minecraft.m_91087_().m_91104_()) {
            float f = slotContext.entity().m_217043_().m_188501_();
            float f2 = slotContext.entity().m_20145_() ? particleSettings.getParticleFrequency() / 2.0f : particleSettings.getParticleFrequency();
            if (f < f2) {
                double d0 = slotContext.entity().m_217043_().m_188583_() * 0.02;
                double d1 = slotContext.entity().m_217043_().m_188583_() * 0.02;
                double d2 = slotContext.entity().m_217043_().m_188583_() * 0.02;
                double y = switch (particleSettings.getParticleMovement()) {
                    default -> throw new IncompatibleClassChangeError();
                    case HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_HEAD -> slotContext.entity().m_20186_() + 1.75;
                    case HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_FEET -> slotContext.entity().m_20186_() + 0.25;
                    case HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_FULL -> slotContext.entity().m_20187_();
                };
                slotContext.entity().f_19853_.m_7106_((ParticleOptions)particleSettings.getParticleType(), slotContext.entity().m_20208_(0.5), y, slotContext.entity().m_20262_(0.5), d0, d1, d2);
            }
        }
    }

    private static void translateToHead(PoseStack poseStack, RenderLayerParent renderLayerParent, LivingEntity entity, float headYaw, float headPitch) {
        if (entity.m_6067_() || entity.m_21255_()) {
            if (renderLayerParent instanceof PlayerModel) {
                PlayerModel layerModel = (PlayerModel)renderLayerParent;
                poseStack.m_85845_(Vector3f.f_122227_.m_122240_(layerModel.f_102808_.f_104205_));
            }
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(headYaw));
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(-45.0f));
        } else {
            if (entity.m_6047_()) {
                poseStack.m_85837_(0.0, 0.25, 0.0);
            }
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(headYaw));
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(headPitch));
        }
        poseStack.m_85837_(0.0, -0.25 - (Double)ModConfig.CLIENT.hatYOffset.get(), (double)0.01f);
    }
}

