/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.shulkerboxslot.platform;

import com.illusivesoulworks.shulkerboxslot.BaseShulkerBoxAccessory;
import com.illusivesoulworks.shulkerboxslot.ShulkerBoxSlotCommonMod;
import com.illusivesoulworks.shulkerboxslot.common.ShulkerBoxSlotForgeNetwork;
import com.illusivesoulworks.shulkerboxslot.common.network.SPacketSyncAnimation;
import com.illusivesoulworks.shulkerboxslot.platform.services.ICommonPlatform;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class ForgeCommonPlatform
implements ICommonPlatform {
    @Override
    public Optional<Triple<ItemStack, String, Integer>> findShulkerBoxAccessory(LivingEntity livingEntity) {
        return CuriosApi.getCuriosHelper().findFirstCurio(livingEntity, stack -> ShulkerBoxSlotCommonMod.isShulkerBox(stack.m_41720_())).map(result -> ImmutableTriple.of((Object)result.stack(), (Object)result.slotContext().identifier(), (Object)result.slotContext().index()));
    }

    @Override
    public Optional<BaseShulkerBoxAccessory> getShulkerBoxAccessory(ItemStack stack) {
        ICurio curio = (ICurio)CuriosApi.getCuriosHelper().getCurio(stack).orElse(null);
        if (curio instanceof BaseShulkerBoxAccessory) {
            BaseShulkerBoxAccessory shulkerBoxAccessory = (BaseShulkerBoxAccessory)curio;
            return Optional.of(shulkerBoxAccessory);
        }
        return Optional.empty();
    }

    @Override
    public Optional<BaseShulkerBoxAccessory> getShulkerBoxAccessory(LivingEntity livingEntity, String id, int index) {
        AtomicReference result = new AtomicReference();
        CuriosApi.getCuriosHelper().getCuriosHandler(livingEntity).ifPresent(curiosHandler -> curiosHandler.getStacksHandler(id).ifPresent(stacksHandler -> {
            if (index < stacksHandler.getSlots()) {
                ItemStack stack = stacksHandler.getStacks().getStackInSlot(index);
                CuriosApi.getCuriosHelper().getCurio(stack).ifPresent(curio -> {
                    if (curio instanceof BaseShulkerBoxAccessory) {
                        BaseShulkerBoxAccessory shulkerBoxAccessory = (BaseShulkerBoxAccessory)curio;
                        result.set(shulkerBoxAccessory);
                    }
                });
            }
        }));
        return Optional.ofNullable((BaseShulkerBoxAccessory)result.get());
    }

    @Override
    public void openScreen(MenuProvider container, ServerPlayer player) {
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)container);
    }

    @Override
    public void sendSyncPacket(SPacketSyncAnimation packet, ServerPlayer player) {
        ShulkerBoxSlotForgeNetwork.get().send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)packet);
    }
}

