/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.shulkerboxslot.common.network;

import com.illusivesoulworks.shulkerboxslot.platform.Services;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;

public record SPacketSyncAnimation(int entityId, String identifier, int index, boolean isClosing) {
    public static void encode(SPacketSyncAnimation msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.entityId);
        buf.m_130070_(msg.identifier);
        buf.writeInt(msg.index);
        buf.writeBoolean(msg.isClosing);
    }

    public static SPacketSyncAnimation decode(FriendlyByteBuf buf) {
        return new SPacketSyncAnimation(buf.readInt(), buf.m_130136_(25), buf.readInt(), buf.readBoolean());
    }

    public static void handle(SPacketSyncAnimation msg) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            return;
        }
        Entity entity = world.m_6815_(msg.entityId);
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        Services.INSTANCE.getShulkerBoxAccessory(livingEntity, msg.identifier, msg.index).ifPresent(shulkerBoxAccessory -> shulkerBoxAccessory.setAnimationStatus(msg.isClosing ? ShulkerBoxBlockEntity.AnimationStatus.CLOSING : ShulkerBoxBlockEntity.AnimationStatus.OPENING));
    }
}

