/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.shulkerboxslot.common;

import com.illusivesoulworks.shulkerboxslot.common.network.CPacketOpenShulkerBox;
import com.illusivesoulworks.shulkerboxslot.common.network.SPacketSyncAnimation;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class ShulkerBoxSlotForgeNetwork {
    private static final String PTC_VERSION = "1";
    private static SimpleChannel instance;
    private static int id;

    public static SimpleChannel get() {
        return instance;
    }

    public static void setup() {
        instance = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("shulkerboxslot", "main")).networkProtocolVersion(() -> PTC_VERSION).clientAcceptedVersions(PTC_VERSION::equals).serverAcceptedVersions(PTC_VERSION::equals).simpleChannel();
        ShulkerBoxSlotForgeNetwork.registerC2S(CPacketOpenShulkerBox.class, CPacketOpenShulkerBox::encode, CPacketOpenShulkerBox::decode, CPacketOpenShulkerBox::handle);
        ShulkerBoxSlotForgeNetwork.registerS2C(SPacketSyncAnimation.class, SPacketSyncAnimation::encode, SPacketSyncAnimation::decode, SPacketSyncAnimation::handle);
    }

    public static <M> void registerC2S(Class<M> clazz, BiConsumer<M, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, M> decoder, BiConsumer<M, ServerPlayer> handler) {
        instance.registerMessage(id++, clazz, encoder, decoder, (message, contextSupplier) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
            context.enqueueWork(() -> {
                ServerPlayer sender = context.getSender();
                if (sender != null) {
                    handler.accept(message, sender);
                }
            });
            context.setPacketHandled(true);
        });
    }

    public static <M> void registerS2C(Class<M> clazz, BiConsumer<M, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, M> decoder, Consumer<M> handler) {
        instance.registerMessage(id++, clazz, encoder, decoder, (message, contextSupplier) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
            context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> handler.accept(message)));
            context.setPacketHandled(true);
        });
    }

    static {
        id = 0;
    }
}

