/*
 * Decompiled with CFR 0.152.
 */
package com.shieldmechanics;

import com.shieldmechanics.ShieldDataGatherer;
import com.shieldmechanics.config.Configuration;
import com.shieldmechanics.enchant.Enchants;
import com.shieldmechanics.event.ClientEventHandler;
import com.shieldmechanics.event.EventHandler;
import com.shieldmechanics.event.ModEventHandler;
import java.util.Random;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="shieldmechanics")
public class Shieldmechanics {
    public static final String MODID = "shieldmechanics";
    public static final Random rand = new Random();
    public static final Logger LOGGER = LogManager.getLogger();
    public static Configuration config = new Configuration();

    public Shieldmechanics() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Shieldmechanics.config.getCommonConfig().ForgeConfigSpecBuilder);
        ((IEventBus)Mod.EventBusSubscriber.Bus.MOD.bus().get()).register(ModEventHandler.class);
        ((IEventBus)Mod.EventBusSubscriber.Bus.FORGE.bus().get()).register(EventHandler.class);
        ((IEventBus)Mod.EventBusSubscriber.Bus.FORGE.bus().get()).addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        Enchants.init();
    }

    @SubscribeEvent
    public void clientSetup(FMLClientSetupEvent event) {
        ((IEventBus)Mod.EventBusSubscriber.Bus.FORGE.bus().get()).register(ClientEventHandler.class);
    }

    private void setup(ServerStartingEvent event) {
        ShieldDataGatherer.parseFromConfig();
        ShieldDataGatherer.detectItems();
        LOGGER.info("Shield mechanics initialized");
    }

    public static boolean isShield(Item item) {
        return item instanceof ShieldItem || item.canPerformAction(item.m_7968_(), ToolActions.SHIELD_BLOCK);
    }

    public static boolean isShield(ItemStack stack) {
        return stack.m_41720_() instanceof ShieldItem || stack.m_41720_().canPerformAction(stack, ToolActions.SHIELD_BLOCK);
    }
}

