/*
 * Decompiled with CFR 0.152.
 */
package com.shieldmechanics;

import com.shieldmechanics.Shieldmechanics;
import com.shieldmechanics.enchant.BlockDamageEnchant;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class ShieldDataGatherer {
    public static Map<ResourceLocation, ShieldData> shields = new HashMap<ResourceLocation, ShieldData>();

    public static float getBlockDamageReductionFor(ItemStack stack) {
        ShieldData data = shields.get(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()));
        if (data == null) {
            return (float)(100 - ShieldDataGatherer.getDefaultBlockReductionPct(stack)) / 100.0f;
        }
        return Math.max(0.0f, data.onBlockDamageReduction - (float)BlockDamageEnchant.getAdditionalBlockChanceFor(stack) / 100.0f);
    }

    public static float getHoldDamageReductionFor(ItemStack stack) {
        ShieldData data = shields.get(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()));
        if (data == null) {
            return (float)(100 - ShieldDataGatherer.getDefaultHoldReductionPct(stack)) / 100.0f;
        }
        return data.onHoldDamageReduction;
    }

    public static void parseFromConfig() {
        shields = new HashMap<ResourceLocation, ShieldData>();
        for (String entry : (List)Shieldmechanics.config.getCommonConfig().shields.get()) {
            int blockedPassiveDamagePercent;
            int blockedDamagePercent;
            String[] splitEntry = entry.split(";");
            if (splitEntry.length != 3) {
                Shieldmechanics.LOGGER.error("Config entry could not be parsed, wrong amount of parameters: " + entry);
                continue;
            }
            ResourceLocation main = ResourceLocation.m_135820_((String)splitEntry[0]);
            if (main == null) {
                Shieldmechanics.LOGGER.error("Config entry could not be parsed, not a valid resource location " + splitEntry[0]);
                continue;
            }
            Item item = (Item)ForgeRegistries.ITEMS.getValue(main);
            if (item == null) {
                Shieldmechanics.LOGGER.error("Config entry could not be parsed, not a valid item" + splitEntry[0]);
                continue;
            }
            try {
                blockedDamagePercent = Integer.parseInt(splitEntry[1]);
                blockedPassiveDamagePercent = Integer.parseInt(splitEntry[2]);
            }
            catch (Exception e) {
                Shieldmechanics.LOGGER.error("Config entry could not be parsed, not a number" + splitEntry[1] + splitEntry[2]);
                continue;
            }
            shields.put(main, new ShieldData(blockedDamagePercent, blockedPassiveDamagePercent));
        }
    }

    public static void detectItems() {
        boolean newEntries = false;
        for (Map.Entry itemEntry : ForgeRegistries.ITEMS.getEntries()) {
            if (!Shieldmechanics.isShield((Item)itemEntry.getValue()) || shields.containsKey(ForgeRegistries.ITEMS.getKey((Object)((Item)itemEntry.getValue())))) continue;
            shields.put(ForgeRegistries.ITEMS.getKey((Object)((Item)itemEntry.getValue())), ShieldData.generateForItem(((Item)itemEntry.getValue()).getMaxDamage(((Item)itemEntry.getValue()).m_7968_())));
            Shieldmechanics.LOGGER.info("Found new shield item, adding: " + ForgeRegistries.ITEMS.getKey((Object)((Item)itemEntry.getValue())) + " with stats: Durability: " + ((Item)itemEntry.getValue()).getMaxDamage(((Item)itemEntry.getValue()).m_7968_()) + " BlockDamageReduction: " + ShieldDataGatherer.shields.get((Object)ForgeRegistries.ITEMS.getKey((Object)((Item)itemEntry.getValue()))).onBlockDamageReductionPercent + " HoldDamageReduction: " + ShieldDataGatherer.shields.get((Object)ForgeRegistries.ITEMS.getKey((Object)((Item)itemEntry.getValue()))).onHoldDamageReductionPercent);
            newEntries = true;
        }
        if (newEntries) {
            ArrayList<CallSite> configList = new ArrayList<CallSite>();
            for (Map.Entry<ResourceLocation, ShieldData> entry : shields.entrySet()) {
                configList.add((CallSite)((Object)(entry.getKey() + ";" + entry.getValue().onBlockDamageReductionPercent + ";" + entry.getValue().onHoldDamageReductionPercent)));
            }
            Shieldmechanics.config.getCommonConfig().shields.set(Arrays.asList(configList.toArray(new String[0])));
        }
    }

    public static int getDefaultBlockReductionPct(ItemStack stack) {
        int durability = stack.m_41776_();
        return (int)Math.min((float)((Integer)Shieldmechanics.config.getCommonConfig().maxblockdamagereduction.get()).intValue(), (float)durability / 336.0f * 65.0f);
    }

    public static int getDefaultHoldReductionPct(ItemStack stack) {
        int durability = stack.m_41776_();
        return (int)Math.min((float)((Integer)Shieldmechanics.config.getCommonConfig().maxpassivedamagereduction.get()).intValue(), (float)durability / 336.0f * 15.0f);
    }

    public static class ShieldData {
        private static final float DEFAULT_SHIELD_DURABILITY = 336.0f;
        private static final int DEFAULT_SHIELD_BLOCK_REDUCTION = 50;
        private static final int DEFAULT_SHIELD_HOLD_REDUCTION = 10;
        private static final int BASE_VARIANCE = 20;
        private static final double GAIN_FOR_100PERCENT = 8.3;
        private float onBlockDamageReduction;
        public int onBlockDamageReductionPercent;
        private float onHoldDamageReduction;
        public int onHoldDamageReductionPercent;

        private ShieldData(int onBlockDamageReductionPercent, int onHoldDamageReductionPercent) {
            this.onBlockDamageReductionPercent = Math.min(onBlockDamageReductionPercent, (Integer)Shieldmechanics.config.getCommonConfig().maxblockdamagereduction.get());
            this.onBlockDamageReduction = Math.max(0.0f, (float)(100 - onBlockDamageReductionPercent) / 100.0f);
            this.onHoldDamageReductionPercent = Math.min(onHoldDamageReductionPercent, (Integer)Shieldmechanics.config.getCommonConfig().maxpassivedamagereduction.get());
            this.onHoldDamageReduction = Math.max(0.0f, (float)(100 - onHoldDamageReductionPercent) / 100.0f);
        }

        static ShieldData generateForItem(int durability) {
            double durabilityModifier = Math.log((float)durability / 336.0f);
            durabilityModifier += (double)(Shieldmechanics.rand.nextInt(60) - 30) / 100.0;
            double blockPercentBonus = Math.min(Math.max((double)Shieldmechanics.rand.nextInt(100) / 100.0, (double)Shieldmechanics.rand.nextInt(100) / 100.0) * (durabilityModifier += 2.4096385542168672), Math.max(10.0, (double)((Integer)Shieldmechanics.config.getCommonConfig().maxblockdamagereduction.get() - 50)) / 8.3);
            double holdPercentBonus = Math.min((durabilityModifier - blockPercentBonus) / 2.0, Math.max(1.0, (double)((Integer)Shieldmechanics.config.getCommonConfig().maxpassivedamagereduction.get() - 10)) / 8.3);
            blockPercentBonus += durabilityModifier - (holdPercentBonus + blockPercentBonus);
            blockPercentBonus = Math.min(blockPercentBonus, Math.max(10.0, (double)((Integer)Shieldmechanics.config.getCommonConfig().maxblockdamagereduction.get() - 50)) / 8.3);
            holdPercentBonus += (durabilityModifier - (holdPercentBonus + blockPercentBonus)) / 2.0;
            holdPercentBonus = Math.min(holdPercentBonus, Math.max(1.0, (double)((Integer)Shieldmechanics.config.getCommonConfig().maxpassivedamagereduction.get() - 10)) / 8.3);
            int blockReduction = 50 + (int)(8.3 * blockPercentBonus);
            int holdReduction = 10 + (int)(8.3 * holdPercentBonus);
            return new ShieldData(blockReduction, holdReduction);
        }
    }
}

