/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.sapience.util;

import com.infamous.sapience.mixin.AnimalAccessor;
import com.infamous.sapience.mixin.MobAccessor;
import com.infamous.sapience.util.HoglinTasksHelper;
import com.infamous.sapience.util.MobInteraction;
import com.infamous.sapience.util.PiglinTasksHelper;
import com.infamous.sapience.util.ReflectionHelper;
import com.infamous.sapience.util.ReputationHelper;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.event.ForgeEventFactory;

public class GeneralHelper {
    public static final int ANGER_ID = 16;
    public static final int DECLINE_ID = 6;
    public static final int ACCEPT_ID = 8;

    public static void spawnParticles(LivingEntity livingEntity, ParticleOptions particleData) {
        for (int i = 0; i < 5; ++i) {
            double randomXSpeed = livingEntity.m_217043_().m_188583_() * 0.02;
            double randomYSpeed = livingEntity.m_217043_().m_188583_() * 0.02;
            double randomZSpeed = livingEntity.m_217043_().m_188583_() * 0.02;
            livingEntity.f_19853_.m_7106_(particleData, livingEntity.m_20208_(1.0), livingEntity.m_20187_() + 1.0, livingEntity.m_20262_(1.0), randomXSpeed, randomYSpeed, randomZSpeed);
        }
    }

    public static boolean isNotOnSameTeam(LivingEntity entityIn, LivingEntity livingentity) {
        return !GeneralHelper.isOnSameTeam(entityIn, livingentity);
    }

    public static boolean isOnSameTeam(LivingEntity entityIn, LivingEntity livingentity) {
        return entityIn.m_7307_((Entity)livingentity);
    }

    public static EntityType<?> maybeSpoofHoglin(Entity entity) {
        return entity instanceof Hoglin ? EntityType.f_20456_ : entity.m_6095_();
    }

    public static EntityType<?> maybeSpoofHoglinOrPiglin(Entity entity) {
        return entity instanceof Hoglin ? EntityType.f_20456_ : (entity instanceof Piglin ? EntityType.f_20511_ : entity.m_6095_());
    }

    public static EntityType<?> maybeSpoofPiglinsHunt(Entity entity) {
        return entity.m_6095_().m_204039_(PiglinTasksHelper.PIGLINS_HUNT) ? EntityType.f_20456_ : entity.m_6095_();
    }

    public static EntityType<?> maybeSpoofPiglin(Entity entity) {
        return entity instanceof Piglin ? EntityType.f_20511_ : entity.m_6095_();
    }

    public static InteractionResult handleGiveAnimalFood(Animal animal, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        int age = animal.m_146764_();
        if (!animal.f_19853_.f_46443_ && age == 0 && animal.m_5957_()) {
            ((AnimalAccessor)animal).callUsePlayerItem(player, hand, stack);
            animal.m_27595_(player);
            return InteractionResult.SUCCESS;
        }
        if (animal.m_6162_()) {
            ((AnimalAccessor)animal).callUsePlayerItem(player, hand, stack);
            animal.m_146740_(Animal.m_216967_((int)(-age)), true);
            return InteractionResult.m_19078_((boolean)animal.f_19853_.f_46443_);
        }
        if (animal.f_19853_.f_46443_) {
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public static Optional<? extends Animal> findValidBreedPartner(Animal parent, EntityType<? extends Animal> partnerType) {
        return parent.m_6274_().m_21952_(MemoryModuleType.f_148205_).flatMap(memory -> memory.m_186116_(le -> {
            if (le.m_6095_() == partnerType && le instanceof Animal) {
                Animal potentialPartner = (Animal)le;
                return parent.m_7848_(potentialPartner);
            }
            return false;
        })).map(Animal.class::cast);
    }

    public static Optional<Animal> getBreedTarget(Animal animal) {
        return animal.m_6274_().m_21952_(MemoryModuleType.f_26375_).filter(Animal.class::isInstance).map(Animal.class::cast);
    }

    public static Optional<LivingEntity> getAttackTarget(LivingEntity attacker) {
        return attacker.m_6274_().m_21952_(MemoryModuleType.f_26372_);
    }

    public static void customLooting(Mob mob) {
        if (!mob.f_19853_.f_46443_ && mob.m_21531_() && mob.m_6084_() && !ReflectionHelper.getDead((LivingEntity)mob) && ForgeEventFactory.getMobGriefingEvent((Level)mob.f_19853_, (Entity)mob)) {
            for (ItemEntity itemEntity : mob.f_19853_.m_45976_(ItemEntity.class, mob.m_20191_().m_82377_(1.0, 0.0, 1.0))) {
                ItemStack stack = itemEntity.m_32055_();
                if (itemEntity.m_213877_() || stack.m_41619_() || itemEntity.m_32063_() || !GeneralHelper.customWantsToPickUp(mob, stack)) continue;
                GeneralHelper.customPickUpItem(mob, itemEntity);
            }
        }
    }

    private static void customPickUpItem(Mob mob, ItemEntity itemEntity) {
        if (mob instanceof Hoglin) {
            Hoglin hoglin = (Hoglin)mob;
            mob.m_21053_(itemEntity);
            HoglinTasksHelper.pickUpHoglinItem((Animal)hoglin, itemEntity);
        } else if (mob instanceof Piglin) {
            Piglin piglin = (Piglin)mob;
            mob.m_21053_(itemEntity);
            PiglinTasksHelper.pickUpPiglinItem(piglin, itemEntity);
            if (itemEntity.m_32057_() != null && mob.f_19853_ instanceof ServerLevel) {
                Entity throwerEntity = ((ServerLevel)mob.f_19853_).m_8791_(itemEntity.m_32057_());
                ReputationHelper.setPreviousInteractor((Mob)piglin, throwerEntity);
            }
        }
    }

    public static boolean customWantsToPickUp(Mob mob, ItemStack stack) {
        boolean bl;
        if (mob instanceof Hoglin) {
            Hoglin hoglin = (Hoglin)mob;
            bl = HoglinTasksHelper.wantsToPickUp(hoglin, stack);
        } else {
            Piglin piglin;
            bl = mob instanceof Piglin && PiglinTasksHelper.wantsToPickUp(piglin = (Piglin)mob, stack);
        }
        return bl;
    }

    public static TagKey<EntityType<?>> createEntityTag(ResourceLocation location) {
        return TagKey.m_203882_((ResourceKey)Registry.f_122903_, (ResourceLocation)location);
    }

    public static boolean hasAnyOf(Container container, TagKey<Item> tagKey) {
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack itemstack = container.m_8020_(i);
            if (!itemstack.m_204117_(tagKey) || itemstack.m_41613_() <= 0) continue;
            return true;
        }
        return false;
    }

    public static <M extends Mob> InteractionResult interactOn(Player player, M target, InteractionHand hand, MobInteraction<M> mobInteraction) {
        ItemStack itemInHand = player.m_21120_(hand);
        ItemStack copy = itemInHand.m_41777_();
        InteractionResult interactionresult = GeneralHelper.interact(target, player, hand, mobInteraction);
        if (interactionresult.m_19077_()) {
            if (player.m_150110_().f_35937_ && itemInHand == player.m_21120_(hand) && itemInHand.m_41613_() < copy.m_41613_()) {
                itemInHand.m_41764_(copy.m_41613_());
            }
            if (!player.m_150110_().f_35937_ && itemInHand.m_41619_()) {
                ForgeEventFactory.onPlayerDestroyItem((Player)player, (ItemStack)copy, (InteractionHand)hand);
            }
            return interactionresult;
        }
        if (!itemInHand.m_41619_()) {
            InteractionResult interactionResult;
            if (player.m_150110_().f_35937_) {
                itemInHand = copy;
            }
            if ((interactionResult = itemInHand.m_41647_(player, target, hand)).m_19077_()) {
                if (itemInHand.m_41619_() && !player.m_150110_().f_35937_) {
                    ForgeEventFactory.onPlayerDestroyItem((Player)player, (ItemStack)copy, (InteractionHand)hand);
                    player.m_21008_(hand, ItemStack.f_41583_);
                }
                return interactionResult;
            }
        }
        return InteractionResult.PASS;
    }

    public static <M extends Mob> InteractionResult interact(M mob, Player player, InteractionHand hand, MobInteraction<M> mobInteraction) {
        if (!mob.m_6084_()) {
            return InteractionResult.PASS;
        }
        if (mob.m_21524_() == player) {
            mob.m_21455_(true, !player.m_150110_().f_35937_);
            return InteractionResult.m_19078_((boolean)mob.f_19853_.f_46443_);
        }
        InteractionResult interactionResult = ((MobAccessor)mob).callCheckAndHandleImportantInteractions(player, hand);
        if (interactionResult.m_19077_()) {
            return interactionResult;
        }
        interactionResult = mobInteraction.apply(mob, player, hand);
        if (interactionResult.m_19077_()) {
            mob.m_146850_(GameEvent.f_223708_);
            return interactionResult;
        }
        return InteractionResult.PASS;
    }
}

