/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.sapience.capability.ageable;

import com.infamous.sapience.SapienceConfig;

public interface Ageable {
    public boolean wasBorn();

    public void setBorn(boolean var1);

    public int getGrowingAge();

    public int getForcedAge();

    public int getForcedAgeTimer();

    public void ageUp(int var1, boolean var2);

    public void addGrowth(int var1);

    public void setGrowingAge(int var1);

    public void setForcedAge(int var1);

    public void setForcedAgeTimer(int var1);

    public void onGrowingAdult();

    public byte getFoodLevel();

    public void setFoodLevel(byte var1);

    public void depleteFoodValue();

    public boolean canBreed();

    public boolean canSelfAge();

    default public void decreaseFoodLevel(int qty) {
        this.setFoodLevel((byte)(this.getFoodLevel() - qty));
    }

    default public void increaseFoodLevel(int qty) {
        this.setFoodLevel((byte)(this.getFoodLevel() + qty));
    }

    public static class Impl
    implements Ageable {
        public static final int FORCED_AGE_TIME = 40;
        private boolean wasBorn;
        private int growingAge;
        private int forcedAge;
        private int forcedAgeTimer;
        private byte foodLevel;

        @Override
        public boolean wasBorn() {
            return this.wasBorn;
        }

        @Override
        public void setBorn(boolean wasBorn) {
            this.wasBorn = wasBorn;
        }

        @Override
        public int getGrowingAge() {
            return this.growingAge;
        }

        @Override
        public int getForcedAge() {
            return this.forcedAge;
        }

        @Override
        public int getForcedAgeTimer() {
            return this.forcedAgeTimer;
        }

        @Override
        public void ageUp(int growthSeconds, boolean updateForcedAge) {
            int growingAge;
            int originalAge = growingAge = this.getGrowingAge();
            if ((growingAge += growthSeconds * 20) > 0) {
                growingAge = 0;
            }
            int ageAmount = growingAge - originalAge;
            this.setGrowingAge(growingAge);
            if (updateForcedAge) {
                this.forcedAge += ageAmount;
                if (this.forcedAgeTimer == 0) {
                    this.forcedAgeTimer = 40;
                }
            }
            if (this.getGrowingAge() == 0) {
                this.setGrowingAge(this.forcedAge);
            }
        }

        @Override
        public void addGrowth(int growth) {
            this.ageUp(growth, false);
        }

        @Override
        public void setGrowingAge(int age) {
            int i = this.growingAge;
            this.growingAge = age;
            if (i < 0 && age >= 0 || i >= 0 && age < 0) {
                this.onGrowingAdult();
            }
        }

        @Override
        public void setForcedAge(int forcedAge) {
            this.forcedAge = forcedAge;
        }

        @Override
        public void setForcedAgeTimer(int forcedAgeTimer) {
            this.forcedAgeTimer = forcedAgeTimer;
        }

        @Override
        public void onGrowingAdult() {
        }

        @Override
        public byte getFoodLevel() {
            return this.foodLevel;
        }

        @Override
        public void setFoodLevel(byte foodLevel) {
            this.foodLevel = foodLevel;
        }

        @Override
        public void depleteFoodValue() {
            this.decreaseFoodLevel((Integer)SapienceConfig.COMMON.MIN_FOOD_VALUE_FOR_BREEDING.get());
        }

        @Override
        public boolean canBreed() {
            return this.getFoodLevel() >= (Integer)SapienceConfig.COMMON.MIN_FOOD_VALUE_FOR_BREEDING.get() && this.getGrowingAge() == 0;
        }

        @Override
        public boolean canSelfAge() {
            return this.getFoodLevel() >= (Integer)SapienceConfig.COMMON.MIN_FOOD_VALUE_FOR_BREEDING.get() && this.getGrowingAge() < 0;
        }
    }
}

