/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.common.entities.goal;

import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;

public class FollowLeaderGoal
extends Goal {
    private final PathfinderMob entity;
    private LivingEntity leader;
    private final Class<? extends LivingEntity> leaderType;
    private final double speedModifier;
    private int timeToRecalculatePath;

    public FollowLeaderGoal(PathfinderMob entity, Class<? extends LivingEntity> leaderType, double speedModifier) {
        this.entity = entity;
        this.leaderType = leaderType;
        this.speedModifier = speedModifier;
    }

    public boolean m_8036_() {
        List entities = this.entity.f_19853_.m_45976_(this.leaderType, this.entity.m_20191_().m_82377_(8.0, 4.0, 8.0));
        LivingEntity leader = null;
        double maxDistance = Double.MAX_VALUE;
        for (LivingEntity entity : entities) {
            double distance = this.entity.m_20280_((Entity)entity);
            if (!(distance <= maxDistance)) continue;
            maxDistance = distance;
            leader = entity;
        }
        if (leader == null) {
            return false;
        }
        if (maxDistance < 9.0) {
            return false;
        }
        this.leader = leader;
        return false;
    }

    public boolean m_8045_() {
        if (!this.leader.m_6084_()) {
            return false;
        }
        double distance = this.entity.m_20270_((Entity)this.leader);
        return !(distance < 9.0) && !(distance > 256.0);
    }

    public void m_8056_() {
        this.timeToRecalculatePath = 0;
    }

    public void m_8041_() {
        this.leader = null;
    }

    public void m_8037_() {
        if (--this.timeToRecalculatePath <= 0) {
            this.timeToRecalculatePath = this.m_183277_(10);
            this.entity.m_21573_().m_5624_((Entity)this.leader, this.speedModifier);
        }
    }
}

