/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.respiteful.entries.builders;

import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.builders.AbstractBuilder;
import com.tterrag.registrate.builders.BuilderCallback;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import com.tterrag.registrate.providers.RegistrateTagsProvider;
import com.tterrag.registrate.util.nullness.NonNullBiFunction;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import com.tterrag.registrate.util.nullness.NonnullType;
import net.minecraft.core.Registry;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraftforge.common.util.NonNullFunction;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class MobEffectBuilder<T extends MobEffect, P>
extends AbstractBuilder<MobEffect, T, P, MobEffectBuilder<T, P>> {
    public static final ProviderType<RegistrateTagsProvider<MobEffect>> MOB_EFFECT_TAGS = ProviderType.register((String)"tags/mob_effect", type -> (p, e) -> new RegistrateTagsProvider(p, type, "mob_effect", e.getGenerator(), Registry.f_122823_, e.getExistingFileHelper()));
    private final NonNullBiFunction<MobEffectCategory, Integer, T> factory;
    protected MobEffectCategory category = MobEffectCategory.NEUTRAL;
    protected int color = 0xFFFFFF;
    @Nullable
    protected String description;

    public static <T extends MobEffect, P> MobEffectBuilder<T, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, NonNullBiFunction<MobEffectCategory, Integer, T> factory) {
        return new MobEffectBuilder<T, P>(owner, parent, name, callback, factory).defaultLang();
    }

    protected MobEffectBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, NonNullBiFunction<MobEffectCategory, Integer, T> factory) {
        super(owner, parent, name, callback, ForgeRegistries.Keys.MOB_EFFECTS);
        this.factory = factory;
    }

    public MobEffectBuilder<T, P> category(MobEffectCategory category) {
        this.category = category;
        return this;
    }

    public MobEffectBuilder<T, P> color(int color) {
        this.color = color & 0xFFFFFF;
        return this;
    }

    public MobEffectBuilder<T, P> description(String description) {
        this.description = description;
        return this;
    }

    @SafeVarargs
    public final MobEffectBuilder<T, P> tag(TagKey<MobEffect> ... tags) {
        return (MobEffectBuilder)this.tag(MOB_EFFECT_TAGS, tags);
    }

    public MobEffectBuilder<T, P> defaultLang() {
        return this.lang(MobEffect::m_19481_);
    }

    public MobEffectBuilder<T, P> lang(String name) {
        return this.lang(MobEffect::m_19481_, name);
    }

    public MobEffectBuilder<T, P> lang(NonNullFunction<T, String> langKeyProvider) {
        return this.lang(langKeyProvider, (p, t) -> p.getAutomaticName(t, this.getRegistryKey()));
    }

    public MobEffectBuilder<T, P> lang(NonNullFunction<T, String> langKeyProvider, String name) {
        return this.lang(langKeyProvider, (p, s) -> name);
    }

    private MobEffectBuilder<T, P> lang(NonNullFunction<T, String> langKeyProvider, NonNullBiFunction<RegistrateLangProvider, NonNullSupplier<? extends T>, String> localizedNameProvider) {
        return (MobEffectBuilder)this.setData(ProviderType.LANG, (ctx, prov) -> {
            String langKey = (String)langKeyProvider.apply((Object)((MobEffect)ctx.getEntry()));
            prov.add(langKey, (String)localizedNameProvider.apply(prov, () -> ((DataGenContext)ctx).getEntry()));
            if (this.description != null) {
                prov.add(langKey + ".description", this.description);
            }
        });
    }

    @NonnullType
    protected T createEntry() {
        return (T)((MobEffect)this.factory.apply((Object)this.category, (Object)this.color));
    }
}

