/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.respiteful.entries;

import com.google.common.collect.ImmutableMap;
import com.teamabnormals.neapolitan.common.block.FlavoredCakeBlock;
import com.teamabnormals.neapolitan.common.block.FlavoredCandleCakeBlock;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import com.tterrag.registrate.providers.loot.RegistrateBlockLootTables;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.registries.RegistryObject;
import plus.dragons.respiteful.Respiteful;
import plus.dragons.respiteful.common.block.IceCreamBlock;
import plus.dragons.respiteful.data.RespitefulBlockStates;
import plus.dragons.respiteful.data.RespitefulBlockTags;
import plus.dragons.respiteful.data.RespitefulRecipes;
import plus.dragons.respiteful.entries.RespitefulItems;
import umpaz.farmersrespite.common.registry.FRItems;

public class RespitefulBlocks {
    private static final LinkedHashMap<Block, String> CANDLE_NAMES = new LinkedHashMap();
    public static final BlockEntry<FlavoredCakeBlock> GREEN_TEA_CAKE;
    public static final ImmutableMap<Block, BlockEntry<FlavoredCandleCakeBlock>> GREEN_TEA_CANDLE_CAKES;
    public static final BlockEntry<FlavoredCakeBlock> YELLOW_TEA_CAKE;
    public static final ImmutableMap<Block, BlockEntry<FlavoredCandleCakeBlock>> YELLOW_TEA_CANDLE_CAKES;
    public static final BlockEntry<FlavoredCakeBlock> BLACK_TEA_CAKE;
    public static final ImmutableMap<Block, BlockEntry<FlavoredCandleCakeBlock>> BLACK_TEA_CANDLE_CAKES;
    public static final BlockEntry<IceCreamBlock> GREEN_TEA_ICE_CREAM_BLOCK;
    public static final BlockEntry<IceCreamBlock> YELLOW_TEA_ICE_CREAM_BLOCK;
    public static final BlockEntry<IceCreamBlock> BLACK_TEA_ICE_CREAM_BLOCK;
    public static final BlockEntry<IceCreamBlock> COFFEE_ICE_CREAM_BLOCK;

    private static ImmutableMap<Block, BlockEntry<FlavoredCandleCakeBlock>> candleBlocks(BlockEntry<FlavoredCakeBlock> cake, TagKey<Block> dropSliceTag) {
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (Map.Entry<Block, String> entry : CANDLE_NAMES.entrySet()) {
            Block candle = entry.getKey();
            String candleName = entry.getValue();
            String cakeName = cake.getId().m_135815_();
            String candleEnName = RegistrateLangProvider.toEnglishName((String)candleName);
            String cakeEnName = RegistrateLangProvider.toEnglishName((String)cakeName);
            map.put((Object)candle, (Object)Respiteful.REGISTRATE.block(candleName + "_" + cakeName, prop -> new FlavoredCandleCakeBlock(() -> ((BlockEntry)cake).get(), candle, prop)).initialProperties(cake).lang(cakeEnName + " with " + candleEnName).blockstate(RespitefulBlockStates::candleCake).tag(new TagKey[]{BlockTags.f_144268_, dropSliceTag}).loot((loot, block) -> loot.m_124165_((Block)block, RegistrateBlockLootTables.m_176058_((Block)candle))).register());
        }
        return map.build();
    }

    public static void register() {
    }

    static {
        CANDLE_NAMES.put(Blocks.f_152482_, "candle");
        CANDLE_NAMES.put(Blocks.f_152483_, "white_candle");
        CANDLE_NAMES.put(Blocks.f_152484_, "orange_candle");
        CANDLE_NAMES.put(Blocks.f_152511_, "magenta_candle");
        CANDLE_NAMES.put(Blocks.f_152512_, "light_blue_candle");
        CANDLE_NAMES.put(Blocks.f_152513_, "yellow_candle");
        CANDLE_NAMES.put(Blocks.f_152514_, "lime_candle");
        CANDLE_NAMES.put(Blocks.f_152515_, "pink_candle");
        CANDLE_NAMES.put(Blocks.f_152516_, "gray_candle");
        CANDLE_NAMES.put(Blocks.f_152517_, "light_gray_candle");
        CANDLE_NAMES.put(Blocks.f_152518_, "cyan_candle");
        CANDLE_NAMES.put(Blocks.f_152519_, "purple_candle");
        CANDLE_NAMES.put(Blocks.f_152520_, "blue_candle");
        CANDLE_NAMES.put(Blocks.f_152521_, "brown_candle");
        CANDLE_NAMES.put(Blocks.f_152522_, "green_candle");
        CANDLE_NAMES.put(Blocks.f_152523_, "red_candle");
        CANDLE_NAMES.put(Blocks.f_152524_, "black_candle");
        GREEN_TEA_CAKE = ((BlockBuilder)Respiteful.REGISTRATE.block("green_tea_cake", prop -> new FlavoredCakeBlock(RespitefulItems.RespitefulFoods.GREEN_TEA_CAKE, prop)).initialProperties(() -> Blocks.f_50145_).properties(prop -> prop.m_155949_(MaterialColor.f_76405_)).blockstate(RespitefulBlockStates::cake).tag(new TagKey[]{RespitefulBlockTags.DROPS_GREEN_TEA_CAKE_SLICE}).loot((loot, block) -> loot.m_124165_((Block)block, BlockLoot.m_124125_())).item().properties(prop -> prop.m_41487_(1)).defaultModel().recipe((ctx, prov) -> RespitefulRecipes.cake((DataGenContext<Item, ? extends Item>)ctx, prov, (NonNullSupplier<? extends Item>)((NonNullSupplier)() -> ((RegistryObject)FRItems.GREEN_TEA_LEAVES).get()), RespitefulItems.GREEN_TEA_CAKE_SLICE)).build()).register();
        GREEN_TEA_CANDLE_CAKES = RespitefulBlocks.candleBlocks(GREEN_TEA_CAKE, RespitefulBlockTags.DROPS_GREEN_TEA_CAKE_SLICE);
        YELLOW_TEA_CAKE = ((BlockBuilder)Respiteful.REGISTRATE.block("yellow_tea_cake", prop -> new FlavoredCakeBlock(RespitefulItems.RespitefulFoods.YELLOW_TEA_CAKE, prop)).initialProperties(() -> Blocks.f_50145_).properties(prop -> prop.m_155949_(MaterialColor.f_76363_)).blockstate(RespitefulBlockStates::cake).tag(new TagKey[]{RespitefulBlockTags.DROPS_YELLOW_TEA_CAKE_SLICE}).loot((loot, block) -> loot.m_124165_((Block)block, BlockLoot.m_124125_())).item().properties(prop -> prop.m_41487_(1)).defaultModel().recipe((ctx, prov) -> RespitefulRecipes.cake((DataGenContext<Item, ? extends Item>)ctx, prov, (NonNullSupplier<? extends Item>)((NonNullSupplier)() -> ((RegistryObject)FRItems.YELLOW_TEA_LEAVES).get()), RespitefulItems.YELLOW_TEA_CAKE_SLICE)).build()).register();
        YELLOW_TEA_CANDLE_CAKES = RespitefulBlocks.candleBlocks(YELLOW_TEA_CAKE, RespitefulBlockTags.DROPS_YELLOW_TEA_CAKE_SLICE);
        BLACK_TEA_CAKE = ((BlockBuilder)Respiteful.REGISTRATE.block("black_tea_cake", prop -> new FlavoredCakeBlock(RespitefulItems.RespitefulFoods.BLACK_TEA_CAKE, prop)).initialProperties(() -> Blocks.f_50145_).properties(prop -> prop.m_155949_(MaterialColor.f_76388_)).blockstate(RespitefulBlockStates::cake).tag(new TagKey[]{RespitefulBlockTags.DROPS_BLACK_TEA_CAKE_SLICE}).loot((loot, block) -> loot.m_124165_((Block)block, BlockLoot.m_124125_())).item().properties(prop -> prop.m_41487_(1)).defaultModel().recipe((ctx, prov) -> RespitefulRecipes.cake((DataGenContext<Item, ? extends Item>)ctx, prov, (NonNullSupplier<? extends Item>)((NonNullSupplier)() -> ((RegistryObject)FRItems.BLACK_TEA_LEAVES).get()), RespitefulItems.BLACK_TEA_CAKE_SLICE)).build()).register();
        BLACK_TEA_CANDLE_CAKES = RespitefulBlocks.candleBlocks(BLACK_TEA_CAKE, RespitefulBlockTags.DROPS_BLACK_TEA_CAKE_SLICE);
        GREEN_TEA_ICE_CREAM_BLOCK = ((BlockBuilder)Respiteful.REGISTRATE.block("green_tea_ice_cream_block", IceCreamBlock::new).initialProperties(() -> Blocks.f_50127_).properties(prop -> prop.m_155949_(MaterialColor.f_76417_)).tag(new TagKey[]{BlockTags.f_144283_}).recipe((ctx, prov) -> RespitefulRecipes.iceCreamBlock((DataGenContext<Block, ? extends Block>)ctx, prov, RespitefulItems.GREEN_TEA_ICE_CREAM)).item().tab(() -> CreativeModeTab.f_40749_).build()).register();
        YELLOW_TEA_ICE_CREAM_BLOCK = ((BlockBuilder)Respiteful.REGISTRATE.block("yellow_tea_ice_cream_block", IceCreamBlock::new).initialProperties(() -> Blocks.f_50127_).properties(prop -> prop.m_155949_(MaterialColor.f_76376_)).tag(new TagKey[]{BlockTags.f_144283_}).recipe((ctx, prov) -> RespitefulRecipes.iceCreamBlock((DataGenContext<Block, ? extends Block>)ctx, prov, RespitefulItems.YELLOW_TEA_ICE_CREAM)).item().tab(() -> CreativeModeTab.f_40749_).build()).register();
        BLACK_TEA_ICE_CREAM_BLOCK = ((BlockBuilder)Respiteful.REGISTRATE.block("black_tea_ice_cream_block", IceCreamBlock::new).initialProperties(() -> Blocks.f_50127_).properties(prop -> prop.m_155949_(MaterialColor.f_76384_)).tag(new TagKey[]{BlockTags.f_144283_}).recipe((ctx, prov) -> RespitefulRecipes.iceCreamBlock((DataGenContext<Block, ? extends Block>)ctx, prov, RespitefulItems.BLACK_TEA_ICE_CREAM)).item().tab(() -> CreativeModeTab.f_40749_).build()).register();
        COFFEE_ICE_CREAM_BLOCK = ((BlockBuilder)Respiteful.REGISTRATE.block("coffee_ice_cream_block", IceCreamBlock::new).initialProperties(() -> Blocks.f_50127_).properties(prop -> prop.m_155949_(MaterialColor.f_76362_)).tag(new TagKey[]{BlockTags.f_144283_}).recipe((ctx, prov) -> RespitefulRecipes.iceCreamBlock((DataGenContext<Block, ? extends Block>)ctx, prov, RespitefulItems.COFFEE_ICE_CREAM)).item().tab(() -> CreativeModeTab.f_40749_).build()).register();
    }
}

