/*
 * Decompiled with CFR 0.152.
 */
package net.productivevillagers;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.RedStoneOreBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.productivevillagers.Config;
import net.productivevillagers.WorkstationDepot;

public class VillagerMethod {
    private static final Map<DyeColor, ItemLike> ITEM_BY_DYE = (Map)Util.m_137469_((Object)Maps.newEnumMap(DyeColor.class), enumMap -> {
        enumMap.put(DyeColor.WHITE, Blocks.f_50041_);
        enumMap.put(DyeColor.ORANGE, Blocks.f_50042_);
        enumMap.put(DyeColor.MAGENTA, Blocks.f_50096_);
        enumMap.put(DyeColor.LIGHT_BLUE, Blocks.f_50097_);
        enumMap.put(DyeColor.YELLOW, Blocks.f_50098_);
        enumMap.put(DyeColor.LIME, Blocks.f_50099_);
        enumMap.put(DyeColor.PINK, Blocks.f_50100_);
        enumMap.put(DyeColor.GRAY, Blocks.f_50101_);
        enumMap.put(DyeColor.LIGHT_GRAY, Blocks.f_50102_);
        enumMap.put(DyeColor.CYAN, Blocks.f_50103_);
        enumMap.put(DyeColor.PURPLE, Blocks.f_50104_);
        enumMap.put(DyeColor.BLUE, Blocks.f_50105_);
        enumMap.put(DyeColor.BROWN, Blocks.f_50106_);
        enumMap.put(DyeColor.GREEN, Blocks.f_50107_);
        enumMap.put(DyeColor.RED, Blocks.f_50108_);
        enumMap.put(DyeColor.BLACK, Blocks.f_50109_);
    });

    public static void process(Villager ve) {
        if (ve.f_19853_.f_46443_) {
            return;
        }
        GlobalPos globalPos = (GlobalPos)ve.m_6274_().m_21952_(MemoryModuleType.f_26360_).get();
        BlockPos p = globalPos.m_122646_();
        VillagerProfession prof = ve.m_7141_().m_35571_();
        Config.ProfessionSetting rec = Config.GetSetting(prof);
        if (rec != null) {
            int req_emeralds = rec.cost;
            boolean paid = req_emeralds < 1;
            for (int i = 0; i < 6; ++i) {
                BlockPos np = p.m_121945_(Direction.values()[i]);
                BlockEntity nbe = ve.f_19853_.m_7702_(np);
                if (nbe == null || ve.f_19853_.m_8055_(np).m_60734_() != WorkstationDepot.THIS_BLOCK.get()) continue;
                Container con = (Container)nbe;
                boolean foundRepairTarget = false;
                boolean foundEmerald = false;
                int emeraldIndex = -1;
                int repairIndex = -1;
                boolean foundActionItem = false;
                int foundActionIndex = -1;
                boolean found_tool = false;
                int found_tool_index = -1;
                Item costItem = (Item)Registry.f_122827_.m_7745_(new ResourceLocation(rec.cost_item));
                for (int ci = 0; ci < con.m_6643_(); ++ci) {
                    ItemStack it = con.m_8020_(ci);
                    if (!foundEmerald && req_emeralds > 0 && it.m_41720_() == costItem) {
                        foundEmerald = true;
                        emeraldIndex = ci;
                    }
                    if (prof == VillagerProfession.f_35589_) {
                        foundActionItem = true;
                    }
                    if (prof == VillagerProfession.f_35590_) {
                        foundActionItem = true;
                    }
                    if (prof == VillagerProfession.f_35587_) {
                        foundActionItem = true;
                    }
                    switch (rec.task_1) {
                        case 2: {
                            if (!(it.m_41720_() instanceof SwordItem) && !(it.m_41720_() instanceof TridentItem) || it.m_41773_() <= 0) break;
                            foundRepairTarget = true;
                            repairIndex = ci;
                            break;
                        }
                        case 1: {
                            if (!(it.m_41720_() instanceof DiggerItem) || it.m_41773_() <= 0) break;
                            foundRepairTarget = true;
                            repairIndex = ci;
                            break;
                        }
                        case 11: {
                            if (!(it.m_41720_() instanceof BowItem) && !(it.m_41720_() instanceof CrossbowItem) || it.m_41773_() <= 0) break;
                            foundRepairTarget = true;
                            repairIndex = ci;
                            break;
                        }
                        case 3: {
                            ArmorItem ai;
                            if (!(it.m_41720_() instanceof ArmorItem) || it.m_41773_() <= 0 || (ai = (ArmorItem)it.m_41720_()).m_40401_() == ArmorMaterials.LEATHER) break;
                            foundRepairTarget = true;
                            repairIndex = ci;
                            break;
                        }
                        case 4: {
                            ArmorItem ai;
                            if (!(it.m_41720_() instanceof ArmorItem) || it.m_41773_() <= 0 || (ai = (ArmorItem)it.m_41720_()).m_40401_() != ArmorMaterials.LEATHER) break;
                            foundRepairTarget = true;
                            repairIndex = ci;
                        }
                    }
                    if (!found_tool && rec.toolreq != Config.ToolRequirement.None && (rec.toolreq == Config.ToolRequirement.Axe && it.m_41720_() instanceof AxeItem || rec.toolreq == Config.ToolRequirement.Pick && it.m_41720_() instanceof PickaxeItem || rec.toolreq == Config.ToolRequirement.Shovel && it.m_41720_() instanceof ShovelItem || rec.toolreq == Config.ToolRequirement.Hoe && it.m_41720_() instanceof HoeItem || rec.toolreq == Config.ToolRequirement.Rod && it.m_41720_() instanceof FishingRodItem || rec.toolreq == Config.ToolRequirement.Shears && it.m_41720_() instanceof ShearsItem || rec.toolreq == Config.ToolRequirement.Sword && it.m_41720_() instanceof SwordItem) && it.m_41773_() < it.m_41776_() - 1) {
                        found_tool = true;
                        found_tool_index = ci;
                    }
                    if (foundActionItem || prof != VillagerProfession.f_35593_ || it.m_41720_() != Items.f_42583_ || it.m_41613_() <= 8) continue;
                    foundActionItem = true;
                    foundActionIndex = ci;
                }
                if (rec.get_recs().size() > 0) {
                    boolean hadEnough = false;
                    for (int c = 0; c < con.m_6643_() && !hadEnough; ++c) {
                        int selected_count;
                        Item selected_output;
                        ItemStack it = con.m_8020_(c);
                        if (it.m_41613_() != 64 || !rec.get_recs().containsKey(it.m_41720_())) continue;
                        Config.StackRecipe sr = rec.get_recs().get(it.m_41720_());
                        if (sr.rare_max > 0 && ve.f_19853_.f_46441_.m_188503_(100) >= 90) {
                            selected_output = (Item)Registry.f_122827_.m_7745_(new ResourceLocation(sr.rare));
                            selected_count = ve.f_19853_.f_46441_.m_216339_(sr.rare_min, sr.rare_max);
                        } else {
                            selected_output = (Item)Registry.f_122827_.m_7745_(new ResourceLocation(sr.output));
                            selected_count = ve.f_19853_.f_46441_.m_216339_(sr.min, sr.max);
                        }
                        con.m_6836_(c, new ItemStack((ItemLike)selected_output, selected_count));
                        if (ve.f_19853_.f_46441_.m_188503_(100) <= 75) continue;
                        hadEnough = true;
                    }
                }
                if (req_emeralds < 1 || foundEmerald) {
                    block7 : switch (rec.task_1) {
                        case 13: {
                            ItemStack foundTool;
                            if (rec.toolreq != Config.ToolRequirement.None && !found_tool) break;
                            boolean foundOre = false;
                            for (int a = 0; a < 64; ++a) {
                                int rx = ve.f_19853_.f_46441_.m_188503_(64) - 32;
                                int ry = ve.f_19853_.f_46441_.m_188503_(8) - 1;
                                int rz = ve.f_19853_.f_46441_.m_188503_(64) - 32;
                                BlockState bs = ve.f_19853_.m_8055_(ve.m_20183_().m_7918_(rx, ry, rz));
                                if (!(bs.m_60734_() instanceof RotatedPillarBlock) || bs.m_60767_() != Material.f_76320_ || !VillagerMethod.try_to_place(new ItemStack((ItemLike)bs.m_60734_(), 1), con)) continue;
                                foundOre = true;
                                if (!found_tool) continue;
                                foundTool = con.m_8020_(found_tool_index);
                                foundTool.m_41721_(foundTool.m_41773_() + 1);
                            }
                            if (!foundOre || paid) break;
                            con.m_8020_(emeraldIndex).m_41774_(1);
                            paid = true;
                            break;
                        }
                        case 12: {
                            ItemStack foundTool;
                            if (rec.toolreq != Config.ToolRequirement.None && !found_tool) break;
                            boolean foundOre = false;
                            for (int a = 0; a < 64; ++a) {
                                int rx = ve.f_19853_.f_46441_.m_188503_(64) - 32;
                                int ry = ve.f_19853_.f_46441_.m_188503_(64) - 32;
                                int rz = ve.f_19853_.f_46441_.m_188503_(64) - 32;
                                BlockState bs = ve.f_19853_.m_8055_(ve.m_20183_().m_7918_(rx, ry, rz));
                                if (!(bs.m_60734_() instanceof DropExperienceBlock) && !(bs.m_60734_() instanceof RedStoneOreBlock) || !VillagerMethod.try_to_place(new ItemStack((ItemLike)bs.m_60734_(), 1), con)) continue;
                                foundOre = true;
                                if (!found_tool) continue;
                                foundTool = con.m_8020_(found_tool_index);
                                foundTool.m_41721_(foundTool.m_41773_() + 1);
                            }
                            if (!foundOre || paid) break;
                            con.m_8020_(emeraldIndex).m_41774_(1);
                            paid = true;
                            break;
                        }
                        case 6: {
                            int l;
                            if (rec.toolreq != Config.ToolRequirement.None && !found_tool) break;
                            List foundCreatures = ve.f_19853_.m_45976_(Mob.class, AABB.m_165882_((Vec3)ve.m_20182_(), (double)16.0, (double)8.0, (double)16.0));
                            boolean didHarvest = false;
                            for (int s = 0; s < foundCreatures.size(); ++s) {
                                if (((Mob)foundCreatures.get(s)).m_6162_() || ve.f_19853_.f_46441_.m_188503_(100) <= 89) continue;
                                Mob mm = (Mob)foundCreatures.get(s);
                                LootContext.Builder builder = new LootContext.Builder((ServerLevel)ve.f_19853_).m_78972_(LootContextParams.f_81460_, (Object)ve.m_20182_()).m_78972_(LootContextParams.f_81457_, (Object)DamageSource.f_19315_).m_78972_(LootContextParams.f_81455_, (Object)ve).m_230911_(ve.f_19853_.f_46441_);
                                LootTable lootTable = ve.f_19853_.m_7654_().m_129898_().m_79217_(mm.m_5743_());
                                ObjectArrayList list = lootTable.m_230922_(builder.m_78975_(LootContextParamSets.f_81415_));
                                for (l = 0; l < list.size(); ++l) {
                                    ItemStack meat = (ItemStack)list.get(l);
                                    if (meat.m_41720_().m_41471_() == CreativeModeTab.f_40749_ || !VillagerMethod.try_to_place(meat, con)) continue;
                                    if (found_tool) {
                                        ItemStack foundTool = con.m_8020_(found_tool_index);
                                        foundTool.m_41721_(foundTool.m_41773_() + 1);
                                    }
                                    if (didHarvest) continue;
                                    ve.f_19853_.m_6269_((Player)null, (Entity)ve, SoundEvents.f_12075_, SoundSource.BLOCKS, 1.0f, 1.0f);
                                    if (!paid) {
                                        con.m_8020_(emeraldIndex).m_41774_(1);
                                        paid = true;
                                    }
                                    didHarvest = true;
                                }
                            }
                            break;
                        }
                        case 5: {
                            if (rec.toolreq != Config.ToolRequirement.None && !found_tool) break;
                            List foundSheep = ve.f_19853_.m_45976_(Sheep.class, AABB.m_165882_((Vec3)ve.m_20182_(), (double)16.0, (double)8.0, (double)16.0));
                            boolean didHarvest = false;
                            for (int s = 0; s < foundSheep.size(); ++s) {
                                ItemStack wool;
                                if (((Sheep)foundSheep.get(s)).m_29875_() || !VillagerMethod.try_to_place(wool = new ItemStack(ITEM_BY_DYE.get(((Sheep)foundSheep.get(s)).m_29874_()), 1), con)) continue;
                                ((Sheep)foundSheep.get(s)).m_29878_(true);
                                if (found_tool) {
                                    ItemStack foundTool = con.m_8020_(found_tool_index);
                                    foundTool.m_41721_(foundTool.m_41773_() + 1);
                                }
                                if (didHarvest) continue;
                                ve.f_19853_.m_6269_((Player)null, (Entity)ve, SoundEvents.f_12344_, SoundSource.BLOCKS, 1.0f, 1.0f);
                                if (!paid) {
                                    con.m_8020_(emeraldIndex).m_41774_(1);
                                    paid = true;
                                }
                                didHarvest = true;
                            }
                            break;
                        }
                        case 9: {
                            boolean didheal = false;
                            List foundVillagers = ve.f_19853_.m_45976_(Villager.class, AABB.m_165882_((Vec3)ve.m_20182_(), (double)32.0, (double)8.0, (double)32.0));
                            for (int v = 0; v < foundVillagers.size(); ++v) {
                                Villager fv = (Villager)foundVillagers.get(v);
                                if (!(fv.m_21223_() < fv.m_21233_() - 1.0f)) continue;
                                fv.m_21153_(fv.m_21233_());
                                didheal = true;
                                if (!paid) {
                                    con.m_8020_(emeraldIndex).m_41774_(1);
                                    paid = true;
                                }
                                ve.f_19853_.m_6269_((Player)null, (Entity)ve, SoundEvents.f_12509_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                                break;
                            }
                            if (didheal) break;
                            List foundPlayers = ve.f_19853_.m_45976_(Player.class, AABB.m_165882_((Vec3)ve.m_20182_(), (double)32.0, (double)8.0, (double)32.0));
                            for (int v = 0; v < foundPlayers.size(); ++v) {
                                Player fv = (Player)foundPlayers.get(v);
                                if (!(fv.m_21223_() < fv.m_21233_() - 1.0f)) continue;
                                float chng = Math.min(6.0f, fv.m_21233_() - fv.m_21223_());
                                fv.m_5634_(chng);
                                didheal = true;
                                if (!paid) {
                                    con.m_8020_(emeraldIndex).m_41774_(1);
                                    paid = true;
                                }
                                ve.f_19853_.m_6269_((Player)null, (Entity)ve, SoundEvents.f_12509_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                                break block7;
                            }
                            break;
                        }
                        case 7: {
                            if (rec.toolreq != Config.ToolRequirement.None && !found_tool) break;
                            boolean harvest = false;
                            for (int vi = 0; vi < ve.m_35311_().m_6643_(); ++vi) {
                                int take;
                                ItemStack fslot = ve.m_35311_().m_8020_(vi);
                                if (fslot.m_41720_() == Items.f_42405_ && fslot.m_41613_() > 1 && VillagerMethod.try_to_place(new ItemStack((ItemLike)Items.f_42405_, take = fslot.m_41613_() - 1), con)) {
                                    ve.m_35311_().m_8020_(vi).m_41774_(take);
                                    harvest = true;
                                }
                                if (fslot.m_41720_() == Items.f_42619_ && fslot.m_41613_() > 1 && VillagerMethod.try_to_place(new ItemStack((ItemLike)Items.f_42619_, take = fslot.m_41613_() - 1), con)) {
                                    ve.m_35311_().m_8020_(vi).m_41774_(take);
                                    harvest = true;
                                }
                                if (fslot.m_41720_() == Items.f_42620_ && fslot.m_41613_() > 1 && VillagerMethod.try_to_place(new ItemStack((ItemLike)Items.f_42620_, take = fslot.m_41613_() - 1), con)) {
                                    ve.m_35311_().m_8020_(vi).m_41774_(take);
                                    harvest = true;
                                }
                                if (fslot.m_41720_() != Items.f_42732_ || fslot.m_41613_() <= 1 || !VillagerMethod.try_to_place(new ItemStack((ItemLike)Items.f_42732_, take = fslot.m_41613_() - 1), con)) continue;
                                ve.m_35311_().m_8020_(vi).m_41774_(take);
                                harvest = true;
                            }
                            if (!harvest || !found_tool) break;
                            ItemStack foundTool = con.m_8020_(found_tool_index);
                            foundTool.m_41721_(foundTool.m_41773_() + 1);
                            break;
                        }
                        case 8: {
                            int rz;
                            int ry;
                            int l;
                            if (rec.toolreq != Config.ToolRequirement.None && !found_tool) break;
                            ItemStack foundTool = rec.toolreq == Config.ToolRequirement.None ? Items.f_42523_.m_7968_() : con.m_8020_(found_tool_index);
                            int rx = ve.f_19853_.f_46441_.m_188503_(17) - 8;
                            BlockState ranbs = ve.f_19853_.m_8055_(p.m_7918_(rx, 0 - (ry = ve.f_19853_.f_46441_.m_188503_(3) + 1), rz = ve.f_19853_.f_46441_.m_188503_(17) - 8));
                            if (ranbs.m_60734_() != Blocks.f_49990_) break;
                            for (l = 0; l < ve.f_19853_.f_46441_.m_188503_(2) + 1; ++l) {
                                ItemStack caught;
                                LootContext.Builder builder = new LootContext.Builder((ServerLevel)ve.f_19853_).m_78972_(LootContextParams.f_81460_, (Object)ve.m_20182_()).m_78972_(LootContextParams.f_81463_, (Object)foundTool).m_78972_(LootContextParams.f_81455_, (Object)ve).m_230911_(ve.f_19853_.f_46441_);
                                LootTable lootTable = ve.f_19853_.m_7654_().m_129898_().m_79217_(BuiltInLootTables.f_78720_);
                                ObjectArrayList list = lootTable.m_230922_(builder.m_78975_(LootContextParamSets.f_81414_));
                                if (list.size() <= 0 || !VillagerMethod.try_to_place(caught = (ItemStack)list.get(0), con)) continue;
                                if (!paid) {
                                    con.m_8020_(emeraldIndex).m_41774_(1);
                                    paid = true;
                                }
                                if (found_tool) {
                                    int newdmg = Math.min(foundTool.m_41773_() + 2, foundTool.m_41776_() - 1);
                                    foundTool.m_41721_(newdmg);
                                }
                                ve.f_19853_.m_6263_((Player)null, ve.m_20185_(), ve.m_20186_(), ve.m_20189_(), SoundEvents.f_11939_, SoundSource.NEUTRAL, 1.0f, 0.4f / (ve.f_19853_.m_213780_().m_188501_() * 0.4f + 0.8f));
                            }
                            break;
                        }
                    }
                }
                if (!foundEmerald || !foundRepairTarget) continue;
                int newv = Math.max(0, con.m_8020_(repairIndex).m_41773_() - 100);
                con.m_8020_(repairIndex).m_41721_(newv);
                if (paid) continue;
                con.m_8020_(emeraldIndex).m_41774_(1);
                paid = true;
            }
        }
    }

    private static boolean try_to_place(ItemStack input, Container con) {
        for (int i = 0; i < con.m_6643_(); ++i) {
            if (con.m_8020_(i).m_41619_()) {
                con.m_6836_(i, input);
                return true;
            }
            if (!input.m_41753_() || con.m_8020_(i).m_41720_() != input.m_41720_() || con.m_8020_(i).m_41613_() + input.m_41613_() > con.m_8020_(i).m_41741_()) continue;
            con.m_8020_(i).m_41769_(input.m_41613_());
            return true;
        }
        return false;
    }
}

