/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.init.ModTags;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class BottlerRecipe
implements Recipe<Container> {
    public final ResourceLocation id;
    public final Pair<String, Integer> fluidInput;
    public final Ingredient itemInput;
    public final ItemStack result;

    public BottlerRecipe(ResourceLocation id, Pair<String, Integer> fluidInput, Ingredient itemInput, ItemStack result) {
        this.id = id;
        this.fluidInput = fluidInput;
        this.itemInput = itemInput;
        this.result = result;
    }

    public boolean matches(FluidStack fluid, ItemStack inputStack) {
        if (!this.itemInput.test(inputStack)) {
            return false;
        }
        if (fluid.getAmount() < (Integer)this.fluidInput.getSecond()) {
            return false;
        }
        Fluid recipeFluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation((String)this.fluidInput.getFirst()));
        if (recipeFluid != null && recipeFluid.equals(fluid.getFluid())) {
            return true;
        }
        TagKey<Fluid> fluidTag = ModTags.getFluidTag(new ResourceLocation((String)this.fluidInput.getFirst()));
        return fluid.getFluid().m_205067_(fluidTag);
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        return false;
    }

    @Nonnull
    public ItemStack m_5874_(Container inv) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack m_8043_() {
        return this.result;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeTypes.BOTTLER.get();
    }

    @Nonnull
    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.BOTTLER_TYPE.get();
    }

    public static class Serializer<T extends BottlerRecipe>
    implements RecipeSerializer<T> {
        final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        @Nonnull
        public T fromJson(ResourceLocation id, JsonObject json) {
            Pair fluidInput = null;
            if (json.has("fluid")) {
                int amount = GsonHelper.m_13824_((JsonObject)json, (String)"amount", (int)250);
                JsonObject fluid = GsonHelper.m_13930_((JsonObject)json, (String)"fluid");
                String fluidResourceLocation = "";
                if (fluid.has("tag")) {
                    fluidResourceLocation = GsonHelper.m_13906_((JsonObject)fluid, (String)"tag");
                } else if (fluid.has("fluid")) {
                    fluidResourceLocation = GsonHelper.m_13906_((JsonObject)fluid, (String)"fluid");
                }
                fluidInput = Pair.of((Object)fluidResourceLocation, (Object)amount);
            }
            Ingredient input = GsonHelper.m_13885_((JsonObject)json, (String)"input") ? Ingredient.m_43917_((JsonElement)GsonHelper.m_13933_((JsonObject)json, (String)"input")) : Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"input"));
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"));
            return this.factory.create(id, fluidInput, input, output);
        }

        public T fromNetwork(@Nonnull ResourceLocation id, @Nonnull FriendlyByteBuf buffer) {
            try {
                Pair fluidInput = Pair.of((Object)buffer.m_130277_(), (Object)buffer.readInt());
                return this.factory.create(id, (Pair<String, Integer>)fluidInput, Ingredient.m_43940_((FriendlyByteBuf)buffer), buffer.m_130267_());
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading bottler recipe from packet. " + id, (Throwable)e);
                throw e;
            }
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, T recipe) {
            try {
                buffer.m_130070_((String)((BottlerRecipe)recipe).fluidInput.getFirst());
                buffer.writeInt(((Integer)((BottlerRecipe)recipe).fluidInput.getSecond()).intValue());
                ((BottlerRecipe)recipe).itemInput.m_43923_(buffer);
                buffer.m_130055_(((BottlerRecipe)recipe).result);
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing bottler recipe to packet. " + ((BottlerRecipe)recipe).m_6423_(), (Throwable)e);
                throw e;
            }
        }

        public static interface IRecipeFactory<T extends BottlerRecipe> {
            public T create(ResourceLocation var1, Pair<String, Integer> var2, Ingredient var3, ItemStack var4);
        }
    }
}

