/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.player.config;

import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import xaero.pac.client.player.config.PlayerConfigClientStorage;
import xaero.pac.common.packet.config.ClientboundPlayerConfigDynamicOptionsPacket;
import xaero.pac.common.server.player.config.PlayerConfig;
import xaero.pac.common.server.player.config.PlayerConfigOptionCategory;
import xaero.pac.common.server.player.config.PlayerConfigOptionSpec;
import xaero.pac.common.server.player.config.api.PlayerConfigType;

public class PlayerConfigListIterationOptionSpec<T extends Comparable<T>>
extends PlayerConfigOptionSpec<T> {
    private final Function<PlayerConfig<?>, List<T>> serverSideListGetter;
    private final Function<PlayerConfigClientStorage, List<T>> clientSideListGetter;

    protected PlayerConfigListIterationOptionSpec(Class<T> type, String id, String shortenedId, List<String> path, T defaultValue, BiFunction<PlayerConfig<?>, T, T> defaultReplacer, String comment, String translation, String[] translationArgs, String commentTranslation, String[] commentTranslationArgs, PlayerConfigOptionCategory category, Function<String, T> commandInputParser, Function<T, Component> commandOutputWriter, BiPredicate<PlayerConfig<?>, T> serverSideValidator, BiPredicate<PlayerConfigClientStorage, T> clientSideValidator, String tooltipPrefix, Predicate<PlayerConfigType> configTypeFilter, Function<PlayerConfig<?>, List<T>> serverSideListGetter, Function<PlayerConfigClientStorage, List<T>> clientSideListGetter, ClientboundPlayerConfigDynamicOptionsPacket.OptionType syncOptionType) {
        super(type, id, shortenedId, path, defaultValue, defaultReplacer, comment, translation, translationArgs, commentTranslation, commentTranslationArgs, category, commandInputParser, commandOutputWriter, serverSideValidator, clientSideValidator, tooltipPrefix, configTypeFilter, syncOptionType);
        this.serverSideListGetter = serverSideListGetter;
        this.clientSideListGetter = clientSideListGetter;
    }

    public Function<PlayerConfig<?>, List<T>> getServerSideListGetter() {
        return this.serverSideListGetter;
    }

    public Function<PlayerConfigClientStorage, List<T>> getClientSideListGetter() {
        return this.clientSideListGetter;
    }

    public static final class FinalBuilder<T extends Comparable<T>>
    extends Builder<T, FinalBuilder<T>> {
        private FinalBuilder(Class<T> type) {
            super(type);
        }

        @Override
        protected PlayerConfigListIterationOptionSpec<T> buildInternally(List<String> path, String shortenedId, Function<String, T> commandInputParser) {
            return new PlayerConfigListIterationOptionSpec<Comparable>(this.type, this.id, shortenedId, path, this.defaultValue, this.defaultReplacer, this.comment, this.translation, this.translationArgs, this.commentTranslation, this.commentTranslationArgs, this.category, commandInputParser, this.commandOutputWriter, this.serverSideValidator, this.clientSideValidator, this.tooltipPrefix, this.configTypeFilter, this.serverSideListGetter, this.clientSideListGetter, ClientboundPlayerConfigDynamicOptionsPacket.OptionType.UNSYNCABLE);
        }

        public static <T extends Comparable<T>> FinalBuilder<T> begin(Class<T> type) {
            return (FinalBuilder)new FinalBuilder<T>(type).setDefault();
        }
    }

    static abstract class Builder<T extends Comparable<T>, B extends Builder<T, B>>
    extends PlayerConfigOptionSpec.Builder<T, B> {
        protected Function<PlayerConfig<?>, List<T>> serverSideListGetter;
        protected Function<PlayerConfigClientStorage, List<T>> clientSideListGetter;

        protected Builder(Class<T> type) {
            super(type);
        }

        @Override
        public B setDefault() {
            this.setServerSideListGetter(null);
            this.setClientSideListGetter(null);
            return (B)((Builder)super.setDefault());
        }

        public B setServerSideListGetter(Function<PlayerConfig<?>, List<T>> serverSideListGetter) {
            this.serverSideListGetter = serverSideListGetter;
            return (B)((Builder)this.self);
        }

        public B setClientSideListGetter(Function<PlayerConfigClientStorage, List<T>> clientSideListGetter) {
            this.clientSideListGetter = clientSideListGetter;
            return (B)((Builder)this.self);
        }

        @Override
        public BiPredicate<PlayerConfig<?>, T> buildServerSideValidator() {
            BiPredicate baseValidator = super.buildServerSideValidator();
            return (c, v) -> baseValidator.test((PlayerConfig<?>)c, v) && this.serverSideListGetter.apply((PlayerConfig<?>)c).contains(v);
        }

        @Override
        public BiPredicate<PlayerConfigClientStorage, T> buildClientSideValidator() {
            BiPredicate baseValidator = super.buildClientSideValidator();
            return (c, v) -> baseValidator.test((PlayerConfigClientStorage)c, v) && this.clientSideListGetter.apply((PlayerConfigClientStorage)c).contains(v);
        }

        @Override
        public PlayerConfigListIterationOptionSpec<T> build(Map<String, PlayerConfigOptionSpec<?>> dest) {
            if (this.serverSideListGetter == null || this.clientSideListGetter == null) {
                throw new IllegalStateException();
            }
            return (PlayerConfigListIterationOptionSpec)super.build(dest);
        }

        @Override
        protected abstract PlayerConfigListIterationOptionSpec<T> buildInternally(List<String> var1, String var2, Function<String, T> var3);
    }
}

