/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.parties.system.impl;

import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamRank;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import xaero.pac.common.server.parties.system.api.IPlayerPartySystemAPI;

public class PlayerFTBPartySystem
implements IPlayerPartySystemAPI<Team> {
    @Override
    @Nullable
    public Team getPartyByOwner(@Nonnull UUID playerId) {
        Team team = FTBTeamsAPI.getPlayerTeam((UUID)playerId);
        if (team == null) {
            return null;
        }
        if (team.getOwner().equals(playerId)) {
            return team;
        }
        return null;
    }

    @Override
    @Nullable
    public Team getPartyByMember(@Nonnull UUID playerId) {
        return FTBTeamsAPI.getPlayerTeam((UUID)playerId);
    }

    @Override
    public boolean isPlayerAllying(@Nonnull UUID playerId, @Nonnull UUID potentialAllyPlayerId) {
        Team playerTeam = this.getPartyByMember(playerId);
        if (playerTeam == null) {
            return false;
        }
        Team potentialAllyPlayerTeam = this.getPartyByMember(potentialAllyPlayerId);
        return playerTeam != potentialAllyPlayerTeam && playerTeam.isAlly(potentialAllyPlayerId);
    }

    @Override
    public boolean isPermittedToPartyClaim(@Nonnull UUID playerId) {
        Team playerTeam = this.getPartyByMember(playerId);
        return playerTeam != null && playerTeam.getHighestRank(playerId).ordinal() >= TeamRank.OFFICER.ordinal();
    }
}

