/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.claims.protection;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class ExceptionElementType<T> {
    private static final List<ExceptionElementType<?>> TYPES = new ArrayList();
    public static final ExceptionElementType<Block> BLOCK = new ExceptionElementType(Registry.f_122901_);
    public static final ExceptionElementType<EntityType<?>> ENTITY_TYPE = new ExceptionElementType(Registry.f_122903_);
    public static final ExceptionElementType<Item> ITEM = new ExceptionElementType(Registry.f_122904_);
    private final ResourceKey<Registry<T>> registryResourceKey;
    private Iterable<T> iterable;
    private Iterable<TagKey<T>> tagIterable;

    public ExceptionElementType(ResourceKey<Registry<T>> registryResourceKey) {
        this.registryResourceKey = registryResourceKey;
        TYPES.add(this);
    }

    public Registry<T> getRegistry(MinecraftServer server) {
        return (Registry)server.m_206579_().m_6632_(this.registryResourceKey).orElseThrow();
    }

    public Iterable<T> getIterable() {
        return this.iterable;
    }

    public Iterable<TagKey<T>> getTagIterable() {
        return this.tagIterable;
    }

    public static void updateAllIterables(MinecraftServer server) {
        TYPES.forEach(type -> type.updateIterables(server));
    }

    public static void clearAllIterables() {
        TYPES.forEach(type -> {
            type.iterable = null;
            type.tagIterable = null;
        });
    }

    private void updateIterables(MinecraftServer server) {
        Registry<T> registry = this.getRegistry(server);
        this.iterable = registry.m_123024_().toList();
        this.tagIterable = registry.m_203612_().map(Pair::getFirst).toList();
    }
}

