/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.claims.protection;

import java.lang.reflect.Field;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.reflect.Reflection;

public class ChunkProtectionEntityHelper {
    private static EntityDataAccessor<Optional<UUID>> FOX_TRUSTED_UUID_SECONDARY;
    private static EntityDataAccessor<Optional<UUID>> FOX_TRUSTED_UUID_MAIN;

    boolean hostileException(Entity e) {
        if (e instanceof Piglin) {
            return ((Piglin)e).m_6162_();
        }
        return false;
    }

    boolean isHostile(Entity e) {
        return e.m_9236_().m_46791_() != Difficulty.PEACEFUL && !this.hostileException(e) && (e instanceof Enemy || e.m_5720_() == SoundSource.HOSTILE);
    }

    boolean isTamed(Entity e, Player p) {
        UUID owner = this.getTamer(e);
        if (p.m_20148_().equals(owner)) {
            return true;
        }
        if (e instanceof Fox) {
            Fox fox = (Fox)e;
            return FOX_TRUSTED_UUID_MAIN != null && p.m_20148_().equals(((Optional)fox.m_20088_().m_135370_(FOX_TRUSTED_UUID_MAIN)).orElse(null));
        }
        return false;
    }

    UUID getTamer(Entity e) {
        if (e instanceof TamableAnimal) {
            TamableAnimal tameable = (TamableAnimal)e;
            return tameable.m_21824_() ? tameable.m_21805_() : null;
        }
        if (e instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)e;
            return horse.m_30614_() ? horse.m_30615_() : null;
        }
        if (e instanceof Fox) {
            Fox fox = (Fox)e;
            return FOX_TRUSTED_UUID_SECONDARY != null ? (UUID)((Optional)fox.m_20088_().m_135370_(FOX_TRUSTED_UUID_SECONDARY)).orElse(null) : null;
        }
        return null;
    }

    static {
        Field foxTrustSecondaryField = null;
        Field foxTrustMainField = null;
        try {
            foxTrustSecondaryField = Reflection.getFieldReflection(Fox.class, "f_28439_", "field_17951", "Lnet/minecraft/class_2940;");
        }
        catch (Exception e) {
            OpenPartiesAndClaims.LOGGER.error("suppressed exception", (Throwable)e);
        }
        try {
            foxTrustMainField = Reflection.getFieldReflection(Fox.class, "f_28440_", "field_17952", "Lnet/minecraft/class_2940;");
        }
        catch (Exception e) {
            OpenPartiesAndClaims.LOGGER.error("suppressed exception", (Throwable)e);
        }
        if (foxTrustSecondaryField != null) {
            try {
                foxTrustSecondaryField.setAccessible(true);
                FOX_TRUSTED_UUID_SECONDARY = (EntityDataAccessor)foxTrustSecondaryField.get(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (foxTrustMainField != null) {
            try {
                foxTrustMainField.setAccessible(true);
                FOX_TRUSTED_UUID_MAIN = (EntityDataAccessor)foxTrustMainField.get(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

