/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.event;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityMobGriefingEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PermissionsChangedEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.server.permission.events.PermissionGatherEvent;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.event.CommonEvents;
import xaero.pac.common.event.api.OPACServerAddonRegisterEvent;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.core.ServerCore;
import xaero.pac.common.server.data.ServerDataReloadListenerForge;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.player.permission.impl.ForgePermissionsSystem;

public class CommonEventsForge
extends CommonEvents {
    public CommonEventsForge(OpenPartiesAndClaims modMain) {
        super(modMain);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityPlaceBlock(BlockEvent.EntityPlaceEvent event) {
        if (super.onEntityPlaceBlock(event.getLevel(), event.getPos(), event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityMultiPlaceBlock(BlockEvent.EntityMultiPlaceEvent event) {
        if (super.onEntityMultiPlaceBlock(event.getLevel(), event.getReplacedBlockSnapshots().stream().map(BlockSnapshot::getPos), event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onServerAboutToStart(ServerAboutToStartEvent event) throws Throwable {
        super.onServerAboutToStart(event.getServer());
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        super.onServerStarting(event.getServer());
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        super.onPlayerRespawn(event.getEntity());
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        super.onPlayerChangedDimension(event.getEntity());
    }

    @SubscribeEvent
    public void onPlayerLogIn(PlayerEvent.PlayerLoggedInEvent event) {
        super.onPlayerLogIn(event.getEntity());
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        super.onPlayerClone(event.getOriginal(), event.getEntity());
    }

    @SubscribeEvent
    public void onPlayerLogOut(PlayerEvent.PlayerLoggedOutEvent event) {
        super.onPlayerLogOut(event.getEntity());
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) throws Throwable {
        if (lastServerStarted == null || !lastServerStarted.m_18695_()) {
            throw new RuntimeException("The last recorded server does not have the expected value!");
        }
        super.onServerTick(lastServerStarted, event.phase == TickEvent.Phase.START);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) throws Throwable {
        super.onPlayerTick(event.phase == TickEvent.Phase.START, event.side == LogicalSide.SERVER, event.player);
    }

    @SubscribeEvent
    public void onServerStopped(ServerStoppedEvent event) {
        super.onServerStopped(event.getServer());
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        super.onRegisterCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getCommandSelection());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        if (super.onLeftClickBlock(event.getLevel(), event.getPos(), event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onDestroyBlock(BlockEvent.BreakEvent event) {
        if (super.onDestroyBlock(event.getLevel(), event.getPos(), event.getPlayer())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (super.onRightClickBlock(event.getLevel(), event.getPos(), event.getEntity(), event.getHand(), event.getHitVec())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onItemRightClick(PlayerInteractEvent.RightClickItem event) {
        if (super.onItemRightClick(event.getLevel(), event.getPos(), event.getEntity(), event.getHand(), event.getItemStack())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onMobGrief(EntityMobGriefingEvent event) {
        if (event.getEntity() == null) {
            return;
        }
        MinecraftServer server = event.getEntity().m_20194_();
        if (server == null) {
            return;
        }
        if (ServerCore.isMobGriefingForItems(server.m_129921_())) {
            return;
        }
        if (super.onMobGrief(event.getEntity())) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingHurt(LivingAttackEvent event) {
        if (super.onLivingHurt(event.getSource(), (Entity)event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityAttack(AttackEntityEvent event) {
        if (super.onEntityAttack(event.getEntity(), event.getTarget())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        if (super.onEntityInteract((Entity)event.getEntity(), event.getTarget(), event.getHand())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onExplosionDetonate(ExplosionEvent.Detonate event) {
        super.onExplosionDetonate(event.getLevel(), event.getExplosion(), event.getAffectedEntities(), event.getAffectedBlocks());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onChorusFruit(EntityTeleportEvent.ChorusFruit event) {
        if (super.onChorusFruit(event.getEntity(), event.getTarget())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinLevelEvent event) {
        if (super.onEntityJoinWorld(event.getEntity(), event.getLevel(), event.loadedFromDisk())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityEnteringSection(EntityEvent.EnteringSection event) {
        super.onEntityEnteringSection(event.getEntity(), event.getOldPos(), event.getNewPos(), event.didChunkChange());
    }

    @SubscribeEvent
    public void onPermissionsChanged(PermissionsChangedEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            super.onPermissionsChanged(serverPlayer);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onCropTrample(BlockEvent.FarmlandTrampleEvent event) {
        if (super.onCropTrample(event.getEntity(), event.getPos())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onBucketUse(FillBucketEvent event) {
        if (super.onBucketUse((Entity)event.getEntity(), event.getLevel(), event.getTarget(), event.getEmptyBucket())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onTagsUpdate(TagsUpdatedEvent event) {
        super.onTagsUpdate();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onItemPickup(EntityItemPickupEvent event) {
        if (super.onItemPickup((Entity)event.getEntity(), event.getItem())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onMobCheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (super.onMobSpawn((Entity)event.getEntity(), event.getX(), event.getY(), event.getZ(), event.getSpawnReason())) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onAddReloadListenerEvent(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new ServerDataReloadListenerForge());
    }

    @SubscribeEvent
    public void onAddonRegister(OPACServerAddonRegisterEvent event) {
        super.onAddonRegister(event.getServer(), event.getPermissionSystemManager(), event.getPartySystemManagerAPI(), event.getClaimsManagerTrackerAPI());
        event.getPermissionSystemManager().register("permission_api", new ForgePermissionsSystem());
    }

    @SubscribeEvent
    protected void onForgePermissionGather(PermissionGatherEvent.Nodes event) {
        ForgePermissionsSystem.registerNodes(event);
    }

    @Override
    protected void fireAddonRegisterEvent(IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData) {
        MinecraftForge.EVENT_BUS.post((Event)new OPACServerAddonRegisterEvent(serverData.getServer(), serverData.getPlayerPermissionSystemManager(), serverData.getPlayerPartySystemManager(), serverData.getServerClaimsManager().getTracker()));
    }
}

