/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.claims.player;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import xaero.pac.common.claims.player.IPlayerClaimInfo;
import xaero.pac.common.claims.player.PlayerChunkClaim;
import xaero.pac.common.claims.player.PlayerClaimInfoManager;
import xaero.pac.common.claims.player.PlayerClaimPosList;
import xaero.pac.common.claims.player.PlayerDimensionClaims;
import xaero.pac.common.server.player.config.IPlayerConfigManager;
import xaero.pac.common.util.linked.ILinkedChainNode;

public abstract class PlayerClaimInfo<PCI extends PlayerClaimInfo<PCI, M>, M extends PlayerClaimInfoManager<PCI, M>>
implements IPlayerClaimInfo<PlayerDimensionClaims>,
ILinkedChainNode<PCI> {
    protected final PCI self = this;
    protected final M manager;
    private String playerUsername;
    protected final UUID playerId;
    protected final Map<ResourceLocation, PlayerDimensionClaims> claims;
    private boolean destroyed;
    private PCI nextInChain;
    private PCI previousInChain;

    public PlayerClaimInfo(String username, UUID playerId, Map<ResourceLocation, PlayerDimensionClaims> claims, M manager) {
        this.playerUsername = username;
        this.playerId = playerId;
        this.manager = manager;
        this.claims = claims;
    }

    private PlayerDimensionClaims ensureDimension(ResourceLocation dimension) {
        return this.claims.computeIfAbsent(dimension, d -> new PlayerDimensionClaims(this.playerId, (ResourceLocation)d, (Map<PlayerChunkClaim, PlayerClaimPosList>)new HashMap<PlayerChunkClaim, PlayerClaimPosList>()));
    }

    private void removeDimension(ResourceLocation dimension) {
        this.claims.remove(dimension);
    }

    @Override
    @Nullable
    public PlayerDimensionClaims getDimension(@Nonnull ResourceLocation dimension) {
        return this.claims.get(dimension);
    }

    public void onClaim(IPlayerConfigManager configManager, ResourceLocation dimension, PlayerChunkClaim claim, int x, int z) {
        PlayerDimensionClaims dimensionClaims = this.ensureDimension(dimension);
        dimensionClaims.addClaim(x, z, claim);
    }

    public void onUnclaim(IPlayerConfigManager configManager, ResourceLocation dimension, PlayerChunkClaim claim, int x, int z) {
        PlayerDimensionClaims dimensionClaims = this.ensureDimension(dimension);
        if (!dimensionClaims.removeClaim(x, z, claim)) {
            throw new IllegalStateException();
        }
        if (dimensionClaims.getCount() <= 0) {
            this.removeDimension(dimension);
        }
    }

    protected abstract Stream<Map.Entry<ResourceLocation, PlayerDimensionClaims>> getDimensionClaimCountStream();

    protected abstract Stream<Map.Entry<ResourceLocation, PlayerDimensionClaims>> getDimensionForceloadCountStream();

    @Override
    public int getClaimCount() {
        return this.getDimensionClaimCountStream().mapToInt(e -> ((PlayerDimensionClaims)e.getValue()).getCount()).sum();
    }

    @Override
    public int getForceloadCount() {
        return this.getDimensionForceloadCountStream().mapToInt(e -> ((PlayerDimensionClaims)e.getValue()).getForceloadableCount()).sum();
    }

    @Override
    @Nonnull
    public UUID getPlayerId() {
        return this.playerId;
    }

    @Override
    @Nonnull
    public Stream<Map.Entry<ResourceLocation, PlayerDimensionClaims>> getStream() {
        return this.claims.entrySet().stream();
    }

    public String toString() {
        return String.format("[%s, %d, %d]:%s", this.playerId, this.getClaimCount(), this.getForceloadCount(), super.toString());
    }

    @Override
    @Nonnull
    public String getPlayerUsername() {
        return this.playerUsername;
    }

    public void setPlayerUsername(String playerUsername) {
        this.playerUsername = playerUsername;
    }

    @Override
    public String getClaimsName() {
        return this.getClaimsName(-1);
    }

    @Override
    public int getClaimsColor() {
        return this.getClaimsColor(-1);
    }

    @Override
    public void setNext(PCI element) {
        this.nextInChain = element;
    }

    @Override
    public void setPrevious(PCI element) {
        this.previousInChain = element;
    }

    @Override
    public PCI getNext() {
        return this.nextInChain;
    }

    @Override
    public PCI getPrevious() {
        return this.previousInChain;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public void onDestroyed() {
        this.destroyed = true;
    }
}

