/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.nutritionalbalance.nutrients;

import com.dannyandson.nutritionalbalance.api.INutritionalBalancePlayer;
import com.dannyandson.nutritionalbalance.api.IPlayerNutrient;
import com.dannyandson.nutritionalbalance.capabilities.DefaultNutritionalBalancePlayer;
import com.dannyandson.nutritionalbalance.nutrients.Nutrient;
import com.dannyandson.nutritionalbalance.nutrients.WorldNutrients;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;

public class PlayerNutritionData
extends SavedData {
    private static PlayerNutritionData worldNutritionData;
    Map<String, INutritionalBalancePlayer> playerUUIDDataMap = new HashMap<String, INutritionalBalancePlayer>();

    public static void init(ServerLevel serverLevel) {
        worldNutritionData = (PlayerNutritionData)serverLevel.m_8895_().m_164861_(PlayerNutritionData::new, PlayerNutritionData::new, "nutritionalbalance");
    }

    public static PlayerNutritionData getWorldNutritionData() {
        if (worldNutritionData == null) {
            worldNutritionData = new PlayerNutritionData();
        }
        return worldNutritionData;
    }

    PlayerNutritionData() {
    }

    PlayerNutritionData(CompoundTag nbt) {
        for (String uuid : nbt.m_128431_()) {
            DefaultNutritionalBalancePlayer nutritionalBalancePlayer = new DefaultNutritionalBalancePlayer();
            CompoundTag playerNBT = (CompoundTag)nbt.m_128423_(uuid);
            for (Nutrient nutrient : WorldNutrients.get()) {
                nutritionalBalancePlayer.getPlayerNutrientByName(nutrient.name).setValue(playerNBT.m_128457_(nutrient.name));
            }
            this.playerUUIDDataMap.put(uuid, nutritionalBalancePlayer);
        }
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        for (Map.Entry<String, INutritionalBalancePlayer> entry : this.playerUUIDDataMap.entrySet()) {
            CompoundTag playerNBT = new CompoundTag();
            for (IPlayerNutrient playerNutrient : entry.getValue().getPlayerNutrients()) {
                playerNBT.m_128350_(playerNutrient.getNutrient().name, playerNutrient.getValue());
            }
            nbt.m_128365_(entry.getKey(), (Tag)playerNBT);
        }
        return nbt;
    }

    public INutritionalBalancePlayer getNutritionalBalancePlayer(Player player) {
        String uuid = player.m_20149_();
        if (!this.playerUUIDDataMap.containsKey(uuid)) {
            this.playerUUIDDataMap.put(uuid, new DefaultNutritionalBalancePlayer());
        }
        return this.playerUUIDDataMap.get(uuid);
    }
}

