/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.nutritionalbalance.network;

import com.dannyandson.nutritionalbalance.api.INutritionalBalancePlayer;
import com.dannyandson.nutritionalbalance.api.IPlayerNutrient;
import com.dannyandson.nutritionalbalance.capabilities.DefaultPlayerNutrient;
import com.dannyandson.nutritionalbalance.events.ClientHelpers;
import com.dannyandson.nutritionalbalance.gui.NutrientGUI;
import com.dannyandson.nutritionalbalance.nutrients.Nutrient;
import com.dannyandson.nutritionalbalance.nutrients.PlayerNutritionData;
import com.dannyandson.nutritionalbalance.nutrients.WorldNutrients;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class PlayerSync {
    private JsonObject inutritionalbalancePlayerJson = new JsonObject();
    private boolean openGUI;

    public PlayerSync(INutritionalBalancePlayer iNutritionalBalancePlayer) {
        this(iNutritionalBalancePlayer, false);
    }

    public PlayerSync(INutritionalBalancePlayer iNutritionalBalancePlayer, boolean openGUI) {
        for (IPlayerNutrient iPlayerNutrient : iNutritionalBalancePlayer.getPlayerNutrients()) {
            this.inutritionalbalancePlayerJson.addProperty(iPlayerNutrient.getNutrientName(), (Number)Float.valueOf(iPlayerNutrient.getValue()));
        }
        this.openGUI = openGUI;
    }

    public PlayerSync(FriendlyByteBuf buffer) {
        this.openGUI = buffer.readBoolean();
        String bufferString = buffer.m_130277_();
        this.inutritionalbalancePlayerJson = (JsonObject)new JsonParser().parse(bufferString);
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.openGUI);
        buf.m_130070_(this.inutritionalbalancePlayerJson.toString());
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            INutritionalBalancePlayer iNutritionalBalancePlayer = PlayerNutritionData.getWorldNutritionData().getNutritionalBalancePlayer(ClientHelpers.getLocalPlayer());
            for (Map.Entry jsonElementEntry : this.inutritionalbalancePlayerJson.entrySet()) {
                IPlayerNutrient playerNutrient = iNutritionalBalancePlayer.getPlayerNutrientByName((String)jsonElementEntry.getKey());
                if (playerNutrient == null) {
                    Nutrient worldNutrient = WorldNutrients.getByName((String)jsonElementEntry.getKey());
                    playerNutrient = new DefaultPlayerNutrient(worldNutrient);
                    iNutritionalBalancePlayer.getPlayerNutrients().add(playerNutrient);
                }
                playerNutrient.setValue(((JsonElement)jsonElementEntry.getValue()).getAsFloat());
            }
            if (this.openGUI) {
                NutrientGUI.open();
            }
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
        return true;
    }
}

