/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.nutritionalbalance.lunchbox;

import com.dannyandson.nutritionalbalance.Config;
import com.dannyandson.nutritionalbalance.lunchbox.LunchBoxContainer;
import com.dannyandson.nutritionalbalance.lunchbox.LunchBoxItem;
import com.dannyandson.nutritionalbalance.setup.Registration;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class LunchBoxMenu
extends AbstractContainerMenu {
    private Container container;
    private Inventory playerInventory;
    private ItemStack lunchBox;

    @NotNull
    public static LunchBoxMenu createMenu(int containerId, Inventory playerInventory) {
        return LunchBoxMenu.createMenu(containerId, playerInventory, (Container)LunchBoxContainer.get(((Item)Registration.LUNCHBOX_ITEM.get()).m_7968_()));
    }

    public static LunchBoxMenu createMenu(int containerId, Inventory playerInventory, Container inventory) {
        return new LunchBoxMenu(containerId, playerInventory, inventory);
    }

    protected LunchBoxMenu(int containerId, Inventory playerInventory, Container container) {
        super((MenuType)Registration.LUNCHBOX_MENU_TYPE.get(), containerId);
        LunchBoxMenu.m_38869_((Container)container, (int)((Integer)Config.LUNCHBOX_SLOT_COUNT.get()));
        this.container = container;
        this.playerInventory = playerInventory;
        this.lunchBox = playerInventory.m_36056_();
        int leftCol = 47;
        int ySize = 252;
        container.m_5856_(playerInventory.f_35978_);
        for (int lunchBoxRow = 0; lunchBoxRow < container.m_6643_(); ++lunchBoxRow) {
            this.m_38897_(new Slot(container, lunchBoxRow, leftCol + lunchBoxRow * 18, ySize - 108 - 10){

                public void m_6654_() {
                    LunchBoxMenu.this.m_6199_(this.f_40218_);
                    super.m_6654_();
                }

                public boolean m_5857_(@NotNull ItemStack stack) {
                    return stack.m_41614_() && !(stack.m_41720_() instanceof LunchBoxItem);
                }
            });
        }
        for (int playerInvRow = 0; playerInvRow < 3; ++playerInvRow) {
            for (int playerInvCol = 0; playerInvCol < 9; ++playerInvCol) {
                this.m_38897_(new Slot((Container)playerInventory, playerInvCol + playerInvRow * 9 + 9, leftCol + playerInvCol * 18, ySize - (4 - playerInvRow) * 18 - 10));
            }
        }
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.m_38897_(new Slot((Container)playerInventory, hotbarSlot, leftCol + hotbarSlot * 18, ySize - 24));
        }
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < (Integer)Config.LUNCHBOX_SLOT_COUNT.get() ? !this.m_38903_(itemstack1, (Integer)Config.LUNCHBOX_SLOT_COUNT.get(), this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, (Integer)Config.LUNCHBOX_SLOT_COUNT.get(), false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public boolean m_6875_(@NotNull Player player) {
        return this.container.m_6542_(player) && player.m_21205_() == this.lunchBox;
    }

    public void m_6199_(@NotNull Container container) {
        Container container2 = this.container;
        if (container2 instanceof LunchBoxContainer) {
            LunchBoxContainer lunchBoxContainer = (LunchBoxContainer)container2;
            lunchBoxContainer.save();
        }
        super.m_6199_(container);
    }

    public void setActiveSlot(int slot) {
        Item item = this.lunchBox.m_41720_();
        if (item instanceof LunchBoxItem) {
            LunchBoxItem lunchBoxItem = (LunchBoxItem)item;
            lunchBoxItem.setActiveFood(this.lunchBox, this.container.m_8020_(slot), this.playerInventory.f_35978_.f_19853_.m_5776_());
        }
    }

    public ItemStack getLunchBoxItemStack() {
        return this.lunchBox;
    }
}

