/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.nutritionalbalance.lunchbox;

import com.dannyandson.nutritionalbalance.lunchbox.LunchBoxContainer;
import com.dannyandson.nutritionalbalance.lunchbox.LunchBoxItemRenderer;
import com.dannyandson.nutritionalbalance.lunchbox.LunchBoxMenu;
import com.dannyandson.nutritionalbalance.network.LunchBoxActiveItemSync;
import com.dannyandson.nutritionalbalance.network.ModNetworkHandler;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LunchBoxItem
extends Item {
    public LunchBoxItem() {
        super(new Item.Properties().m_41491_(CreativeModeTab.f_40755_));
    }

    @Nullable
    public FoodProperties getFoodProperties(ItemStack stack, @Nullable LivingEntity entity) {
        if (stack.m_41720_() instanceof LunchBoxItem) {
            ItemStack activeStack = this.getActiveFoodItemStack(stack);
            if (activeStack != null) {
                return activeStack.getFoodProperties(entity);
            }
            return null;
        }
        return super.getFoodProperties(stack, entity);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() instanceof LunchBoxItem) {
            ItemStack activeStack = this.getActiveFoodItemStack(stack);
            if (activeStack != null && !player.m_36341_()) {
                FoodProperties activeFoodProperties = activeStack.getFoodProperties((LivingEntity)player);
                if (!activeStack.m_41619_() && activeFoodProperties != null && activeStack.m_41614_() && !player.m_36335_().m_41519_(activeStack.m_41720_()) && player.m_36391_(activeFoodProperties.m_38747_())) {
                    player.m_6672_(hand);
                    return InteractionResultHolder.m_19096_((Object)stack);
                }
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            if (!level.m_5776_() && !(player.f_36096_ instanceof LunchBoxMenu) && hand == InteractionHand.MAIN_HAND) {
                LunchBoxContainer container = LunchBoxContainer.get(stack);
                player.m_5893_((MenuProvider)new SimpleMenuProvider((containerId, playerInventory, playerEntity) -> new LunchBoxMenu(containerId, playerInventory, (Container)container), (Component)Component.m_237115_((String)this.m_5671_(stack))));
            }
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        return super.m_7203_(level, player, hand);
    }

    @NotNull
    public ItemStack m_5922_(ItemStack stack, @NotNull Level level, @NotNull LivingEntity entity) {
        if (stack.m_41720_() instanceof LunchBoxItem) {
            LunchBoxContainer container;
            ItemStack selectedStack;
            Integer activeSlot;
            if (entity instanceof Player && (activeSlot = this.getActiveFoodItemSlot(stack)) != null && !(selectedStack = (container = LunchBoxContainer.get(stack)).m_8020_(activeSlot)).m_41619_()) {
                ItemStack resultStack = ForgeEventFactory.onItemUseFinish((LivingEntity)entity, (ItemStack)selectedStack.m_41777_(), (int)entity.m_21212_(), (ItemStack)selectedStack.m_41671_(level, entity));
                container.m_6836_(activeSlot, resultStack);
                container.save();
            }
            return stack;
        }
        return super.m_5922_(stack, level, entity);
    }

    public int m_8105_(ItemStack stack) {
        ItemStack activeStack;
        if (stack.m_41720_() instanceof LunchBoxItem && (activeStack = this.getActiveFoodItemStack(stack)) != null) {
            return activeStack.m_41779_();
        }
        return 32;
    }

    @NotNull
    public UseAnim m_6164_(ItemStack stack) {
        ItemStack activeStack;
        if (stack.m_41720_() instanceof LunchBoxItem && (activeStack = this.getActiveFoodItemStack(stack)) != null) {
            return activeStack.m_41780_();
        }
        return super.m_6164_(stack);
    }

    @NotNull
    public Component m_7626_(ItemStack stack) {
        ItemStack activeStack;
        if (stack.m_41720_() instanceof LunchBoxItem && (activeStack = this.getActiveFoodItemStack(stack)) != null) {
            return Component.m_237115_((String)this.m_5671_(stack)).m_130946_(" (").m_7220_(activeStack.m_41720_().m_7626_(activeStack)).m_130946_(")");
        }
        return super.m_7626_(stack);
    }

    public void m_7373_(@NotNull ItemStack stack, @javax.annotation.Nullable Level world, List<Component> list, TooltipFlag flags) {
        if (Screen.m_96638_()) {
            list.add((Component)Component.m_237115_((String)"message.item.lunchbox").m_130940_(ChatFormatting.GRAY));
        } else {
            list.add((Component)Component.m_237115_((String)"nutritionalbalance.tooltip.press_shift").m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }

    public void setActiveFood(ItemStack lunchBoxStack, ItemStack targetItemStack) {
        this.setActiveFood(lunchBoxStack, targetItemStack, false);
    }

    public void setActiveFood(ItemStack lunchBoxStack, ItemStack targetItemStack, Boolean sync) {
        if (lunchBoxStack.m_41720_() instanceof LunchBoxItem && targetItemStack.m_41614_()) {
            this.setActiveFood(lunchBoxStack, targetItemStack.m_41778_());
            if (sync.booleanValue()) {
                ModNetworkHandler.sendToServer(new LunchBoxActiveItemSync(targetItemStack.m_41778_()));
            }
        }
    }

    public void setActiveFood(ItemStack lunchBoxStack, String descriptionId) {
        if (!lunchBoxStack.m_41782_()) {
            lunchBoxStack.m_41751_(new CompoundTag());
        }
        lunchBoxStack.m_41783_().m_128359_("active", descriptionId);
    }

    @CheckForNull
    public Integer getActiveFoodItemSlot(ItemStack lunchBoxStack) {
        if (lunchBoxStack.m_41720_() instanceof LunchBoxItem && lunchBoxStack.m_41782_() && lunchBoxStack.m_41783_().m_128441_("active")) {
            LunchBoxContainer container = LunchBoxContainer.get(lunchBoxStack);
            String activeStack = lunchBoxStack.m_41783_().m_128461_("active");
            for (int i = 0; i < container.m_6643_(); ++i) {
                if (!container.m_8020_(i).m_41778_().equals(activeStack)) continue;
                return i;
            }
        }
        return null;
    }

    @CheckForNull
    public ItemStack getItemStack(ItemStack lunchBoxStack, int slot) {
        if (lunchBoxStack.m_41720_() instanceof LunchBoxItem) {
            LunchBoxContainer container = LunchBoxContainer.get(lunchBoxStack);
            return container.m_8020_(slot);
        }
        return null;
    }

    @CheckForNull
    public ItemStack getActiveFoodItemStack(ItemStack lunchBoxStack) {
        Integer slot = this.getActiveFoodItemSlot(lunchBoxStack);
        if (slot != null) {
            return this.getItemStack(lunchBoxStack, slot);
        }
        return null;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return new LunchBoxItemRenderer(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
            }
        });
    }
}

