/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.nutritionalbalance.events;

import com.dannyandson.nutritionalbalance.Config;
import com.dannyandson.nutritionalbalance.NutritionalBalance;
import com.dannyandson.nutritionalbalance.api.INutritionalBalancePlayer;
import com.dannyandson.nutritionalbalance.api.IPlayerNutrient;
import com.dannyandson.nutritionalbalance.effects.ModMobAffects;
import com.dannyandson.nutritionalbalance.events.ClientHelpers;
import com.dannyandson.nutritionalbalance.network.ModNetworkHandler;
import com.dannyandson.nutritionalbalance.network.PlayerSync;
import com.dannyandson.nutritionalbalance.nutrients.PlayerNutritionData;
import com.dannyandson.nutritionalbalance.setup.Registration;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;

public class EventPlayerTick {
    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Player playerEntity = event.player;
            INutritionalBalancePlayer iNutritionalBalancePlayer = PlayerNutritionData.getWorldNutritionData().getNutritionalBalancePlayer(playerEntity);
            if (!NutritionalBalance.modEffectsLoaded) {
                ModMobAffects.loadModEffects();
            }
            if (!playerEntity.f_19853_.f_46443_) {
                float playerSaturation = playerEntity.m_36324_().m_38722_();
                int playerFoodLevel = playerEntity.m_36324_().m_38702_();
                float foodpoints = playerSaturation + (float)playerFoodLevel;
                iNutritionalBalancePlayer.processSaturationChange(foodpoints);
            }
            if (event.player.f_19797_ % 200 == 0) {
                IPlayerNutrient.NutrientStatus cachedStatus = iNutritionalBalancePlayer.getCachedStatus();
                IPlayerNutrient.NutrientStatus currentStatus = iNutritionalBalancePlayer.getStatus();
                if (event.side == LogicalSide.SERVER) {
                    MobEffectInstance nourished = playerEntity.m_21124_((MobEffect)Registration.NOURISHED_EFFECT.get());
                    MobEffectInstance malnourished = playerEntity.m_21124_((MobEffect)Registration.MALNOURISHED_EFFECT.get());
                    MobEffectInstance engorged = playerEntity.m_21124_((MobEffect)Registration.ENGORGED_EFFECT.get());
                    if (currentStatus == IPlayerNutrient.NutrientStatus.ENGORGED) {
                        if (nourished != null) {
                            playerEntity.m_21195_((MobEffect)Registration.NOURISHED_EFFECT.get());
                        }
                        if (malnourished != null) {
                            playerEntity.m_21195_((MobEffect)Registration.MALNOURISHED_EFFECT.get());
                        }
                        if (engorged == null) {
                            playerEntity.m_7292_(new MobEffectInstance((MobEffect)Registration.ENGORGED_EFFECT.get(), Integer.MAX_VALUE, 0, true, false, true));
                        }
                    } else if (currentStatus == IPlayerNutrient.NutrientStatus.MALNOURISHED) {
                        if (nourished != null) {
                            playerEntity.m_21195_((MobEffect)Registration.NOURISHED_EFFECT.get());
                        }
                        if (malnourished == null) {
                            playerEntity.m_7292_(new MobEffectInstance((MobEffect)Registration.MALNOURISHED_EFFECT.get(), Integer.MAX_VALUE, 0, true, false, true));
                        }
                        if (engorged != null) {
                            playerEntity.m_21195_((MobEffect)Registration.ENGORGED_EFFECT.get());
                        }
                    } else if (currentStatus == IPlayerNutrient.NutrientStatus.ON_TARGET) {
                        if (nourished == null) {
                            playerEntity.m_7292_(new MobEffectInstance((MobEffect)Registration.NOURISHED_EFFECT.get(), Integer.MAX_VALUE, 0, true, false, true));
                        }
                        if (malnourished != null) {
                            playerEntity.m_21195_((MobEffect)Registration.MALNOURISHED_EFFECT.get());
                        }
                        if (engorged != null) {
                            playerEntity.m_21195_((MobEffect)Registration.ENGORGED_EFFECT.get());
                        }
                    } else {
                        if (nourished != null) {
                            playerEntity.m_21195_((MobEffect)Registration.NOURISHED_EFFECT.get());
                        }
                        if (malnourished != null) {
                            playerEntity.m_21195_((MobEffect)Registration.MALNOURISHED_EFFECT.get());
                        }
                        if (engorged != null) {
                            playerEntity.m_21195_((MobEffect)Registration.ENGORGED_EFFECT.get());
                        }
                    }
                }
                if (cachedStatus != currentStatus) {
                    if (playerEntity.f_19853_.m_5776_()) {
                        if (((Boolean)Config.SHOW_THRESHOLD_TOAST.get()).booleanValue()) {
                            ClientHelpers.showStatusToast(currentStatus.name());
                        }
                    } else {
                        PlayerSync playerSync = new PlayerSync(iNutritionalBalancePlayer);
                        ModNetworkHandler.sendToClient(playerSync, (ServerPlayer)playerEntity);
                    }
                }
            }
        }
    }
}

