/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.villagers.json.adapters;

import com.google.gson.JsonObject;
import com.nyfaria.numismaticoverhaul.NumismaticOverhaul;
import com.nyfaria.numismaticoverhaul.currency.Currency;
import com.nyfaria.numismaticoverhaul.currency.CurrencyHelper;
import com.nyfaria.numismaticoverhaul.owostuff.ops.TextOps;
import com.nyfaria.numismaticoverhaul.villagers.json.TradeJsonAdapter;
import com.nyfaria.numismaticoverhaul.villagers.json.VillagerJsonHelper;
import com.nyfaria.numismaticoverhaul.villagers.json.adapters.NumOTrade;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class SellTagAdapter
extends TradeJsonAdapter {
    @Override
    @NotNull
    public VillagerTrades.ItemListing deserialize(JsonObject json) {
        this.loadDefaultStats(json, true);
        VillagerJsonHelper.assertJsonObject(json, "sell");
        JsonObject sellObject = GsonHelper.m_13930_((JsonObject)json, (String)"sell");
        ResourceLocation tag = new ResourceLocation(GsonHelper.m_13906_((JsonObject)sellObject, (String)"tag"));
        int count = GsonHelper.m_13824_((JsonObject)sellObject, (String)"count", (int)1);
        int price = json.get("price").getAsInt();
        return new Factory(tag, count, price, this.max_uses, this.villager_experience, this.price_multiplier);
    }

    private static class Factory
    implements VillagerTrades.ItemListing,
    NumOTrade {
        private final ResourceLocation sellTag;
        private final int count;
        private final int maxUses;
        private final int experience;
        private final int price;
        private final float multiplier;

        public Factory(ResourceLocation sellTag, int count, int price, int maxUses, int experience, float multiplier) {
            this.sellTag = sellTag;
            this.count = count;
            this.maxUses = maxUses;
            this.experience = experience;
            this.price = price;
            this.multiplier = multiplier;
        }

        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            HolderSet.Named entries = Registry.f_122827_.m_203431_(TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)this.sellTag)).orElse(null);
            if (entries == null) {
                NumismaticOverhaul.LOGGER.warn("Could not generate trade for tag '" + this.sellTag + "', as it does not exist");
                Player player = entity.f_19853_.m_45930_(entity, 15.0);
                if (player != null) {
                    player.m_5661_((Component)TextOps.withColor("numismatic \u00a7> there has been a problem generating trades, check the log for details", Currency.GOLD.getNameColor(), TextOps.color(ChatFormatting.GRAY)), false);
                }
                return null;
            }
            ItemStack sellStack = new ItemStack((ItemLike)entries.m_203662_(random.m_188503_(entries.m_203632_())).m_203334_(), this.count);
            return new MerchantOffer(CurrencyHelper.getClosest(this.price), sellStack, this.maxUses, this.experience, this.multiplier);
        }
    }
}

