/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.villagers.json.adapters;

import com.google.gson.JsonObject;
import com.nyfaria.numismaticoverhaul.currency.CurrencyHelper;
import com.nyfaria.numismaticoverhaul.villagers.json.TradeJsonAdapter;
import com.nyfaria.numismaticoverhaul.villagers.json.VillagerJsonHelper;
import com.nyfaria.numismaticoverhaul.villagers.json.adapters.NumOTrade;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.trading.MerchantOffer;
import org.jetbrains.annotations.NotNull;

public class SellPotionContainerItemAdapter
extends TradeJsonAdapter {
    @Override
    @NotNull
    public VillagerTrades.ItemListing deserialize(JsonObject json) {
        this.loadDefaultStats(json, true);
        VillagerJsonHelper.assertJsonObject(json, "container_item");
        VillagerJsonHelper.assertJsonObject(json, "buy_item");
        int price = json.get("price").getAsInt();
        ItemStack container_item = VillagerJsonHelper.getItemStackFromJson(json.get("container_item").getAsJsonObject());
        ItemStack buy_item = VillagerJsonHelper.getItemStackFromJson(json.get("buy_item").getAsJsonObject());
        return new Factory(container_item, buy_item, price, this.max_uses, this.villager_experience, this.price_multiplier);
    }

    private static class Factory
    implements VillagerTrades.ItemListing,
    NumOTrade {
        private final ItemStack containerItem;
        private final ItemStack buyItem;
        private final int price;
        private final int maxUses;
        private final int experience;
        private final float priceMultiplier;

        public Factory(ItemStack containerItem, ItemStack buyItem, int price, int maxUses, int experience, float priceMultiplier) {
            this.containerItem = containerItem;
            this.buyItem = buyItem;
            this.price = price;
            this.maxUses = maxUses;
            this.experience = experience;
            this.priceMultiplier = priceMultiplier;
        }

        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            List<Potion> list = Registry.f_122828_.m_123024_().filter(potion -> !potion.m_43488_().isEmpty() && PotionBrewing.m_43511_((Potion)potion)).toList();
            Potion potion2 = list.get(random.m_188503_(list.size()));
            ItemStack itemStack2 = PotionUtils.m_43549_((ItemStack)this.containerItem.m_41777_(), (Potion)potion2);
            return new MerchantOffer(CurrencyHelper.getClosest(this.price), this.buyItem, itemStack2, this.maxUses, this.experience, this.priceMultiplier);
        }
    }
}

