/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.villagers.json.adapters;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.nyfaria.numismaticoverhaul.currency.CurrencyHelper;
import com.nyfaria.numismaticoverhaul.villagers.json.TradeJsonAdapter;
import com.nyfaria.numismaticoverhaul.villagers.json.VillagerJsonHelper;
import com.nyfaria.numismaticoverhaul.villagers.json.adapters.NumOTrade;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class SellDyedArmorAdapter
extends TradeJsonAdapter {
    @Override
    @NotNull
    public VillagerTrades.ItemListing deserialize(JsonObject json) {
        this.loadDefaultStats(json, true);
        VillagerJsonHelper.assertString(json, "item");
        int price = json.get("price").getAsInt();
        Item item = VillagerJsonHelper.getItemFromID(json.get("item").getAsString());
        return new Factory(item, price, this.max_uses, this.villager_experience, this.price_multiplier);
    }

    private static class Factory
    implements VillagerTrades.ItemListing,
    NumOTrade {
        private final Item sell;
        private final int price;
        private final int maxUses;
        private final int experience;
        private final float priceMultiplier;

        public Factory(Item item, int price, int maxUses, int experience, float priceMultiplier) {
            this.sell = item;
            this.price = price;
            this.maxUses = maxUses;
            this.experience = experience;
            this.priceMultiplier = priceMultiplier;
        }

        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            ItemStack itemStack2 = new ItemStack((ItemLike)this.sell);
            if (this.sell instanceof DyeableLeatherItem) {
                ArrayList list = Lists.newArrayList();
                list.add(Factory.getDye(random));
                if (random.m_188501_() > 0.7f) {
                    list.add(Factory.getDye(random));
                }
                if (random.m_188501_() > 0.8f) {
                    list.add(Factory.getDye(random));
                }
                itemStack2 = DyeableLeatherItem.m_41118_((ItemStack)itemStack2, (List)list);
            }
            return new MerchantOffer(CurrencyHelper.getClosest(this.price), itemStack2, this.maxUses, this.experience, this.priceMultiplier);
        }

        private static DyeItem getDye(RandomSource random) {
            return DyeItem.m_41082_((DyeColor)DyeColor.m_41053_((int)random.m_188503_(16)));
        }
    }
}

