/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.villagers.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.nyfaria.numismaticoverhaul.NumismaticOverhaul;
import com.nyfaria.numismaticoverhaul.villagers.data.NumismaticVillagerTradesRegistry;
import com.nyfaria.numismaticoverhaul.villagers.exceptions.DeserializationContext;
import com.nyfaria.numismaticoverhaul.villagers.exceptions.DeserializationException;
import com.nyfaria.numismaticoverhaul.villagers.json.TradeJsonAdapter;
import com.nyfaria.numismaticoverhaul.villagers.json.adapters.BuyStackAdapter;
import com.nyfaria.numismaticoverhaul.villagers.json.adapters.DimensionAwareSellStackAdapter;
import com.nyfaria.numismaticoverhaul.villagers.json.adapters.EnchantItemAdapter;
import com.nyfaria.numismaticoverhaul.villagers.json.adapters.ProcessItemAdapter;
import com.nyfaria.numismaticoverhaul.villagers.json.adapters.SellDyedArmorAdapter;
import com.nyfaria.numismaticoverhaul.villagers.json.adapters.SellMapAdapter;
import com.nyfaria.numismaticoverhaul.villagers.json.adapters.SellPotionContainerItemAdapter;
import com.nyfaria.numismaticoverhaul.villagers.json.adapters.SellSingleEnchantmentAdapter;
import com.nyfaria.numismaticoverhaul.villagers.json.adapters.SellStackAdapter;
import com.nyfaria.numismaticoverhaul.villagers.json.adapters.SellSusStewAdapter;
import com.nyfaria.numismaticoverhaul.villagers.json.adapters.SellTagAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import org.jetbrains.annotations.NotNull;

public class VillagerTradesHandler {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final Map<String, Integer> professionKeys = new HashMap<String, Integer>();
    public static final Map<ResourceLocation, TradeJsonAdapter> tradeTypesRegistry = new HashMap<ResourceLocation, TradeJsonAdapter>();
    private static final List<DeserializationException> EXCEPTIONS_DURING_LOADING = new ArrayList<DeserializationException>();

    public static void registerDefaultAdapters() {
        tradeTypesRegistry.put(NumismaticOverhaul.id("sell_stack"), new SellStackAdapter());
        tradeTypesRegistry.put(NumismaticOverhaul.id("sell_sus_stew"), new SellSusStewAdapter());
        tradeTypesRegistry.put(NumismaticOverhaul.id("sell_tag"), new SellTagAdapter());
        tradeTypesRegistry.put(NumismaticOverhaul.id("dimension_sell_stack"), new DimensionAwareSellStackAdapter());
        tradeTypesRegistry.put(NumismaticOverhaul.id("sell_map"), new SellMapAdapter());
        tradeTypesRegistry.put(NumismaticOverhaul.id("sell_single_enchantment"), new SellSingleEnchantmentAdapter());
        tradeTypesRegistry.put(NumismaticOverhaul.id("enchant_item"), new EnchantItemAdapter());
        tradeTypesRegistry.put(NumismaticOverhaul.id("process_item"), new ProcessItemAdapter());
        tradeTypesRegistry.put(NumismaticOverhaul.id("sell_dyed_armor"), new SellDyedArmorAdapter());
        tradeTypesRegistry.put(NumismaticOverhaul.id("sell_potion_container"), new SellPotionContainerItemAdapter());
        tradeTypesRegistry.put(NumismaticOverhaul.id("buy_item"), new BuyStackAdapter());
        tradeTypesRegistry.put(NumismaticOverhaul.id("buy_stack"), new BuyStackAdapter());
    }

    public static void loadProfession(ResourceLocation fileId, JsonObject jsonRoot) {
        DeserializationContext.clear();
        String fileName = "\u00a7a" + fileId.m_135827_() + "\u00a7f:\u00a76" + fileId.m_135815_();
        ResourceLocation professionId = ResourceLocation.m_135820_((String)jsonRoot.get("profession").getAsString());
        DeserializationContext.setFile(fileName);
        DeserializationContext.setProfession(professionId.m_135815_());
        try {
            if (professionId.m_135815_().equals("wandering_trader")) {
                VillagerTradesHandler.deserializeTrades(jsonRoot, NumismaticVillagerTradesRegistry::registerWanderingTraderTrade);
            } else {
                VillagerProfession profession = (VillagerProfession)Registry.f_122869_.m_6612_(professionId).orElseThrow(() -> new DeserializationException("Invalid profession"));
                VillagerTradesHandler.deserializeTrades(jsonRoot, (integer, factory) -> NumismaticVillagerTradesRegistry.registerVillagerTrade(profession, integer, factory));
            }
        }
        catch (DeserializationException e) {
            VillagerTradesHandler.addLoadingException(e);
        }
    }

    private static void deserializeTrades(@NotNull JsonObject jsonRoot, BiConsumer<Integer, VillagerTrades.ItemListing> tradeConsumer) {
        if (!jsonRoot.get("trades").isJsonObject()) {
            throw new DeserializationException(jsonRoot.get("trades") + " is not a JsonObject");
        }
        for (Map.Entry entry : jsonRoot.get("trades").getAsJsonObject().entrySet()) {
            int level = professionKeys.get(entry.getKey());
            if (!((JsonElement)entry.getValue()).isJsonArray()) {
                throw new DeserializationException(entry.getValue() + " is not a JsonArray");
            }
            JsonArray tradesArray = ((JsonElement)entry.getValue()).getAsJsonArray();
            for (JsonElement tradeElement : tradesArray) {
                if (!tradeElement.isJsonObject()) {
                    VillagerTradesHandler.addLoadingException(new DeserializationException(tradeElement + " is not a JsonObject"));
                    continue;
                }
                JsonObject trade = tradeElement.getAsJsonObject();
                DeserializationContext.setTrade(trade);
                DeserializationContext.setLevel(level);
                if (!trade.has("type")) {
                    throw new DeserializationException("Type missing");
                }
                TradeJsonAdapter adapter = tradeTypesRegistry.get(ResourceLocation.m_135820_((String)trade.get("type").getAsString()));
                if (adapter == null) {
                    throw new DeserializationException("Unknown trade type " + trade.get("type").getAsString());
                }
                try {
                    tradeConsumer.accept(level, adapter.deserialize(trade));
                }
                catch (DeserializationException e) {
                    VillagerTradesHandler.addLoadingException(e);
                }
            }
        }
    }

    public static void addLoadingException(DeserializationException e) {
        EXCEPTIONS_DURING_LOADING.add(e);
        NumismaticOverhaul.LOGGER.error("");
        NumismaticOverhaul.LOGGER.error(" -- Caught exception during loading trade definitions, full stacktrace commencing -- ");
        NumismaticOverhaul.LOGGER.error("");
        e.printStackTrace();
    }

    public static void broadcastErrors(MinecraftServer server) {
        VillagerTradesHandler.broadcastErrors(server.m_6846_().m_11314_());
    }

    public static void broadcastErrors(List<ServerPlayer> players) {
        if (!EXCEPTIONS_DURING_LOADING.isEmpty()) {
            players.forEach(playerEntity -> {
                playerEntity.m_5661_((Component)Component.m_237113_((String)"\u00a7cThe following errors have occurred during numismaticoverhaul reload:"), false);
                playerEntity.m_5661_((Component)Component.m_237119_(), false);
                EXCEPTIONS_DURING_LOADING.forEach(e -> {
                    MutableComponent message = Component.m_237113_((String)("\u00a77-> " + e.getMessage() + " \u00a78(hover for more info)"));
                    MutableComponent hoverText = Component.m_237113_((String)"");
                    hoverText.m_7220_((Component)Component.m_237113_((String)("File: \u00a77" + e.getContext().file + "\n\n")));
                    hoverText.m_7220_((Component)Component.m_237113_((String)("Profession: \u00a7a" + e.getContext().profession + "\n")));
                    hoverText.m_7220_((Component)Component.m_237113_((String)("Level: \u00a76" + e.getContext().level + "\n\n")));
                    hoverText.m_7220_((Component)Component.m_237113_((String)("Problematic trade: \n\u00a77" + GSON.toJson((JsonElement)e.getContext().trade))));
                    message.m_6270_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)hoverText)));
                    playerEntity.m_5661_((Component)message, false);
                });
            });
            EXCEPTIONS_DURING_LOADING.clear();
        }
    }

    static {
        professionKeys.put("novice", 1);
        professionKeys.put("apprentice", 2);
        professionKeys.put("journeyman", 3);
        professionKeys.put("expert", 4);
        professionKeys.put("master", 5);
    }
}

