/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.villagers.data;

import com.nyfaria.numismaticoverhaul.villagers.data.RemappingTradeWrapper;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import org.apache.commons.lang3.ArrayUtils;

public class NumismaticVillagerTradesRegistry {
    private static final HashMap<VillagerProfession, Int2ObjectOpenHashMap<List<VillagerTrades.ItemListing>>> TRADES_REGISTRY = new HashMap();
    private static final Int2ObjectOpenHashMap<List<VillagerTrades.ItemListing>> WANDERING_TRADER_REGISTRY = new Int2ObjectOpenHashMap();
    private static final HashMap<VillagerProfession, Int2ObjectOpenHashMap<List<VillagerTrades.ItemListing>>> REMAPPED_FABRIC_TRADES = new HashMap();
    private static final Int2ObjectOpenHashMap<List<VillagerTrades.ItemListing>> REMAPPED_FABRIC_WANDERING_TRADER_TRADES = new Int2ObjectOpenHashMap();
    private static final AtomicBoolean MOD_VILLAGERS_WRAPPED = new AtomicBoolean(false);

    public static void registerFabricVillagerTrades(VillagerProfession profession, int level, List<VillagerTrades.ItemListing> factories) {
        NumismaticVillagerTradesRegistry.getVillagerTradeList(REMAPPED_FABRIC_TRADES, profession, level).addAll(factories.stream().map(RemappingTradeWrapper::wrap).toList());
    }

    public static void registerFabricWanderingTraderTrades(int level, List<VillagerTrades.ItemListing> factories) {
        ((List)NumismaticVillagerTradesRegistry.getOrDefaultAndAdd(REMAPPED_FABRIC_WANDERING_TRADER_TRADES, level, new ArrayList())).addAll(factories.stream().map(RemappingTradeWrapper::wrap).toList());
    }

    public static void registerVillagerTrade(VillagerProfession profession, int level, VillagerTrades.ItemListing trade) {
        NumismaticVillagerTradesRegistry.getVillagerTradeList(TRADES_REGISTRY, profession, level).add(trade);
    }

    public static void registerWanderingTraderTrade(int level, VillagerTrades.ItemListing trade) {
        ((List)NumismaticVillagerTradesRegistry.getOrDefaultAndAdd(WANDERING_TRADER_REGISTRY, level, new ArrayList())).add(trade);
    }

    public static void wrapModVillagers() {
        VillagerTrades.f_35627_.forEach((profession, int2TradesMap) -> {
            if (TRADES_REGISTRY.containsKey(profession)) {
                return;
            }
            int2TradesMap.forEach((integer, factories) -> NumismaticVillagerTradesRegistry.registerFabricVillagerTrades(profession, integer, Arrays.asList(factories)));
        });
        MOD_VILLAGERS_WRAPPED.set(true);
    }

    private static List<VillagerTrades.ItemListing> getVillagerTradeList(HashMap<VillagerProfession, Int2ObjectOpenHashMap<List<VillagerTrades.ItemListing>>> registry, VillagerProfession profession, int level) {
        Int2ObjectOpenHashMap villagerMap = NumismaticVillagerTradesRegistry.getOrDefaultAndAdd(registry, profession, new Int2ObjectOpenHashMap());
        return NumismaticVillagerTradesRegistry.getOrDefaultAndAdd(villagerMap, level, new ArrayList());
    }

    public static <K, V> V getOrDefaultAndAdd(Map<K, V> map, K key, V defaultValue) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        map.put(key, defaultValue);
        return defaultValue;
    }

    public static void clearRegistries() {
        TRADES_REGISTRY.clear();
        WANDERING_TRADER_REGISTRY.clear();
    }

    public static Tuple<HashMap<VillagerProfession, Int2ObjectOpenHashMap<VillagerTrades.ItemListing[]>>, Int2ObjectOpenHashMap<VillagerTrades.ItemListing[]>> getRegistryForLoading() {
        RegistryProcessor processor = RegistryProcessor.begin();
        TRADES_REGISTRY.forEach(processor::processProfession);
        REMAPPED_FABRIC_TRADES.forEach((villagerProfession, listInt2ObjectOpenHashMap) -> {
            if (TRADES_REGISTRY.containsKey(villagerProfession)) {
                return;
            }
            processor.processProfession((VillagerProfession)villagerProfession, (Int2ObjectOpenHashMap<List<VillagerTrades.ItemListing>>)listInt2ObjectOpenHashMap);
        });
        WANDERING_TRADER_REGISTRY.forEach(processor::processWanderingTrader);
        REMAPPED_FABRIC_WANDERING_TRADER_TRADES.forEach(processor::processWanderingTrader);
        return processor.finish();
    }

    private static class RegistryProcessor {
        private final HashMap<VillagerProfession, Int2ObjectOpenHashMap<VillagerTrades.ItemListing[]>> villagerTrades = new HashMap();
        private final Int2ObjectOpenHashMap<VillagerTrades.ItemListing[]> wanderingTraderTrades = new Int2ObjectOpenHashMap();

        private RegistryProcessor() {
        }

        public static RegistryProcessor begin() {
            return new RegistryProcessor();
        }

        public void processProfession(VillagerProfession profession, Int2ObjectOpenHashMap<List<VillagerTrades.ItemListing>> professionTradesPerLevel) {
            Int2ObjectOpenHashMap<VillagerTrades.ItemListing[]> factories = this.villagerTrades.getOrDefault(profession, (Int2ObjectOpenHashMap<VillagerTrades.ItemListing[]>)new Int2ObjectOpenHashMap());
            professionTradesPerLevel.forEach((level, factoryList) -> {
                Object[] oldFactories = (VillagerTrades.ItemListing[])factories.getOrDefault(level.intValue(), (Object)new VillagerTrades.ItemListing[0]);
                factories.put(level.intValue(), (Object)((VillagerTrades.ItemListing[])ArrayUtils.addAll((Object[])oldFactories, (Object[])factoryList.toArray(new VillagerTrades.ItemListing[0]))));
            });
            this.villagerTrades.put(profession, factories);
        }

        public void processWanderingTrader(Integer level, List<VillagerTrades.ItemListing> trades) {
            Object[] oldFactories = (VillagerTrades.ItemListing[])this.wanderingTraderTrades.getOrDefault(level.intValue(), (Object)new VillagerTrades.ItemListing[0]);
            this.wanderingTraderTrades.put(level.intValue(), (Object)((VillagerTrades.ItemListing[])ArrayUtils.addAll((Object[])oldFactories, (Object[])trades.toArray(new VillagerTrades.ItemListing[0]))));
        }

        public Tuple<HashMap<VillagerProfession, Int2ObjectOpenHashMap<VillagerTrades.ItemListing[]>>, Int2ObjectOpenHashMap<VillagerTrades.ItemListing[]>> finish() {
            return new Tuple(this.villagerTrades, this.wanderingTraderTrades);
        }
    }
}

