/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.owostuff.ui.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.nyfaria.numismaticoverhaul.owostuff.ops.TextOps;
import com.nyfaria.numismaticoverhaul.owostuff.ui.util.Drawer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class UIErrorToast
implements Toast {
    private final List<FormattedCharSequence> errorMessage;
    private final Font textRenderer;
    private final int width;

    public UIErrorToast(Throwable error) {
        this.textRenderer = Minecraft.m_91087_().f_91062_;
        List<Component> texts = this.initText(String.valueOf(error.getMessage()), consumer -> {
            StackTraceElement stackTop = error.getStackTrace()[0];
            String[] errorLocation = stackTop.getClassName().split("\\.");
            consumer.accept(Component.m_237113_((String)"Type: ").m_130940_(ChatFormatting.RED).m_7220_((Component)Component.m_237113_((String)error.getClass().getSimpleName()).m_130940_(ChatFormatting.GRAY)));
            consumer.accept(Component.m_237113_((String)"Thrown by: ").m_130940_(ChatFormatting.RED).m_7220_((Component)Component.m_237113_((String)(errorLocation[errorLocation.length - 1] + ":" + stackTop.getLineNumber())).m_130940_(ChatFormatting.GRAY)));
        });
        this.width = Math.min(240, TextOps.width(this.textRenderer, texts) + 8);
        this.errorMessage = this.wrap(texts);
    }

    public UIErrorToast(String message) {
        this.textRenderer = Minecraft.m_91087_().f_91062_;
        List<Component> texts = this.initText(message, consumer -> consumer.accept(Component.m_237113_((String)"No context provided").m_130940_(ChatFormatting.GRAY)));
        this.width = Math.min(240, TextOps.width(this.textRenderer, texts) + 8);
        this.errorMessage = this.wrap(texts);
    }

    public static void report(String message) {
        Minecraft.m_91087_().m_91300_().m_94922_((Toast)new UIErrorToast(message));
    }

    public static void report(Throwable error) {
        Minecraft.m_91087_().m_91300_().m_94922_((Toast)new UIErrorToast(error));
    }

    public Toast.Visibility m_7172_(PoseStack matrices, ToastComponent manager, long startTime) {
        Drawer.m_93172_((PoseStack)matrices, (int)0, (int)0, (int)this.m_7828_(), (int)this.m_94899_(), (int)0x77000000);
        Drawer.drawRectOutline(matrices, 0, 0, this.m_7828_(), this.m_94899_(), -1476460544);
        int xOffset = this.m_7828_() / 2 - this.textRenderer.m_92724_(this.errorMessage.get(0)) / 2;
        this.textRenderer.m_92744_(matrices, this.errorMessage.get(0), (float)(4 + xOffset), 4.0f, 0xFFFFFF);
        for (int i = 1; i < this.errorMessage.size(); ++i) {
            this.textRenderer.m_92877_(matrices, this.errorMessage.get(i), 4.0f, (float)(4 + i * 11), 0xFFFFFF);
        }
        return startTime > 10000L ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }

    public int m_94899_() {
        return 6 + this.errorMessage.size() * 11;
    }

    public int m_7828_() {
        return this.width;
    }

    private List<Component> initText(String errorMessage, Consumer<Consumer<Component>> contextAppender) {
        ArrayList<Component> texts = new ArrayList<Component>();
        texts.add((Component)Component.m_237113_((String)"owo-ui error").m_130940_(ChatFormatting.RED));
        texts.add((Component)Component.m_237113_((String)" "));
        contextAppender.accept(texts::add);
        texts.add((Component)Component.m_237113_((String)" "));
        texts.add((Component)Component.m_237113_((String)errorMessage));
        texts.add((Component)Component.m_237113_((String)" "));
        texts.add((Component)Component.m_237113_((String)"Check your log for details").m_130940_(ChatFormatting.GRAY));
        return texts;
    }

    private List<FormattedCharSequence> wrap(List<Component> message) {
        ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
        for (Component text : message) {
            list.addAll(this.textRenderer.m_92923_((FormattedText)text, this.m_7828_() - 8));
        }
        return list;
    }

    public Object m_7283_() {
        return Type.VERY_TYPE;
    }

    static enum Type {
        VERY_TYPE;

    }
}

