/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.owostuff.ui.util;

import com.nyfaria.numismaticoverhaul.owostuff.ui.core.ModComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.ParentComponent;
import java.util.ArrayList;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class FocusHandler {
    protected final ParentComponent root;
    @Nullable
    protected ModComponent focused = null;
    @Nullable
    protected ModComponent.FocusSource lastFocusSource = null;

    public FocusHandler(ParentComponent root) {
        this.root = root;
    }

    public void updateClickFocus(double mouseX, double mouseY) {
        ModComponent clicked = this.root.childAt((int)mouseX, (int)mouseY);
        this.focus(clicked != null && clicked.canFocus(ModComponent.FocusSource.MOUSE_CLICK) ? clicked : null, ModComponent.FocusSource.MOUSE_CLICK);
    }

    @Contract(pure=true)
    @Nullable
    public ModComponent focused() {
        return this.focused;
    }

    public ModComponent.FocusSource lastFocusSource() {
        return this.lastFocusSource;
    }

    public void cycle(boolean forwards) {
        ArrayList<ModComponent> allChildren = new ArrayList<ModComponent>();
        this.root.collectChildren(allChildren);
        allChildren.removeIf(component -> !component.canFocus(ModComponent.FocusSource.KEYBOARD_CYCLE));
        if (allChildren.isEmpty()) {
            return;
        }
        int index = (this.focused == null ? 0 : allChildren.indexOf(this.focused)) + (forwards ? 1 : -1);
        if (index >= allChildren.size()) {
            index -= allChildren.size();
        }
        if (index < 0) {
            index += allChildren.size();
        }
        this.focus(allChildren.get(index), ModComponent.FocusSource.KEYBOARD_CYCLE);
    }

    public void moveFocus(int keyCode) {
        if (this.focused == null) {
            return;
        }
        ArrayList<ModComponent> allChildren = new ArrayList<ModComponent>();
        this.root.collectChildren(allChildren);
        allChildren.removeIf(component -> !component.canFocus(ModComponent.FocusSource.KEYBOARD_CYCLE));
        if (allChildren.isEmpty()) {
            return;
        }
        ModComponent closest = this.focused;
        switch (keyCode) {
            case 262: {
                int closestX = Integer.MAX_VALUE;
                int closestY = Integer.MAX_VALUE;
                for (ModComponent child : allChildren) {
                    if (child == this.focused || child.x() < this.focused.x() + this.focused.width() || child.x() > closestX || Math.abs(child.y() - this.focused.y()) > closestY) continue;
                    closest = child;
                    closestX = child.x();
                    closestY = Math.abs(child.y() - this.focused.y());
                }
                break;
            }
            case 263: {
                int closestX = 0;
                int closestY = Integer.MAX_VALUE;
                for (ModComponent child : allChildren) {
                    if (child == this.focused || child.x() + child.width() > this.focused.x() || child.x() + child.width() < closestX || Math.abs(child.y() - this.focused.y()) > closestY) continue;
                    closest = child;
                    closestX = child.x() + child.width();
                    closestY = Math.abs(child.y() - this.focused.y());
                }
                break;
            }
            case 265: {
                int closestX = Integer.MAX_VALUE;
                int closestY = 0;
                for (ModComponent child : allChildren) {
                    if (child == this.focused || child.y() + child.height() > this.focused.y() || child.y() + child.height() < closestY || Math.abs(child.x() - this.focused.x()) > closestX) continue;
                    closest = child;
                    closestX = Math.abs(child.x() - this.focused.x());
                    closestY = child.y() + child.height();
                }
                break;
            }
            case 264: {
                int closestX = Integer.MAX_VALUE;
                int closestY = Integer.MAX_VALUE;
                for (ModComponent child : allChildren) {
                    if (child == this.focused || child.y() < this.focused.y() + this.focused.height() || child.y() + child.height() > closestY || Math.abs(child.x() - this.focused.x()) > closestX) continue;
                    closest = child;
                    closestX = Math.abs(child.x() - this.focused.x());
                    closestY = child.y() + child.height();
                }
                break;
            }
        }
        this.focus(closest, ModComponent.FocusSource.KEYBOARD_CYCLE);
    }

    public void focus(@Nullable ModComponent component, ModComponent.FocusSource source) {
        if (this.focused != component) {
            if (this.focused != null) {
                this.focused.onFocusLost();
            }
            if ((this.focused = component) != null) {
                this.focused.onFocusGained(source);
                this.lastFocusSource = source;
            } else {
                this.lastFocusSource = null;
            }
        }
    }
}

