/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.owostuff.ui.core;

import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Animatable;
import com.nyfaria.numismaticoverhaul.owostuff.ui.parsing.UIModelParsingException;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.util.Mth;
import org.w3c.dom.Element;

public class Sizing
implements Animatable<Sizing> {
    private static final Sizing CONTENT_SIZING = new Sizing(0, Method.CONTENT);
    public final Method method;
    public final int value;

    private Sizing(int value, Method method) {
        this.method = method;
        this.value = value;
    }

    public void inflate(int space, Consumer<Integer> sizeSetter, Consumer<Sizing> contentSizeFunction) {
        switch (this.method) {
            case FIXED: {
                sizeSetter.accept(this.value);
                break;
            }
            case FILL: {
                sizeSetter.accept(Math.round((float)this.value / 100.0f * (float)space));
                break;
            }
            case CONTENT: {
                contentSizeFunction.accept(this);
            }
        }
    }

    public static Sizing fixed(int value) {
        return new Sizing(value, Method.FIXED);
    }

    public static Sizing content() {
        return CONTENT_SIZING;
    }

    public static Sizing content(int padding) {
        return new Sizing(padding, Method.CONTENT);
    }

    public static Sizing fill(int percent) {
        return new Sizing(percent, Method.FILL);
    }

    @Override
    public Sizing interpolate(Sizing next, float delta) {
        if (next.method != this.method) {
            return this;
        }
        return new Sizing((int)Mth.m_14179_((float)delta, (float)this.value, (float)next.value), this.method);
    }

    public static Sizing parse(Element sizingElement) {
        String methodString = sizingElement.getAttribute("method");
        if (methodString.isBlank()) {
            throw new UIModelParsingException("Missing 'method' attribute on sizing declaration. Must be one of: fixed, content, fill");
        }
        Method method = Method.valueOf(methodString.toUpperCase(Locale.ROOT));
        String value = sizingElement.getTextContent().strip();
        if (method == Method.CONTENT) {
            if (!value.matches("(-?\\d+)?")) {
                throw new UIModelParsingException("Invalid value in sizing declaration");
            }
            return new Sizing(value.isEmpty() ? 0 : Integer.parseInt(value), method);
        }
        if (!value.matches("-?\\d+")) {
            throw new UIModelParsingException("Invalid value in sizing declaration");
        }
        return new Sizing(Integer.parseInt(value), method);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sizing sizing = (Sizing)o;
        return this.value == sizing.value && this.method == sizing.method;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.method, this.value});
    }

    public static enum Method {
        FIXED,
        CONTENT,
        FILL;

    }
}

