/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.owostuff.ui.core;

import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Animatable;
import com.nyfaria.numismaticoverhaul.owostuff.ui.parsing.UIModelParsingException;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.util.Mth;
import org.w3c.dom.Element;

public class Positioning
implements Animatable<Positioning> {
    private static final Positioning LAYOUT_POSITIONING = new Positioning(0, 0, Type.LAYOUT);
    public final Type type;
    public final int x;
    public final int y;

    private Positioning(int x, int y, Type type) {
        this.type = type;
        this.x = x;
        this.y = y;
    }

    public Positioning withX(int x) {
        return new Positioning(x, this.y, this.type);
    }

    public Positioning withY(int y) {
        return new Positioning(this.x, y, this.type);
    }

    @Override
    public Positioning interpolate(Positioning next, float delta) {
        if (next.type != this.type) {
            return this;
        }
        return new Positioning((int)Mth.m_14179_((float)delta, (float)this.x, (float)next.x), (int)Mth.m_14179_((float)delta, (float)this.y, (float)next.y), this.type);
    }

    public static Positioning absolute(int xPixels, int yPixels) {
        return new Positioning(xPixels, yPixels, Type.ABSOLUTE);
    }

    public static Positioning relative(int xPercent, int yPercent) {
        return new Positioning(xPercent, yPercent, Type.RELATIVE);
    }

    public static Positioning layout() {
        return LAYOUT_POSITIONING;
    }

    public static Positioning parse(Element positioningElement) {
        String typeString = positioningElement.getAttribute("type");
        if (typeString.isBlank()) {
            throw new UIModelParsingException("Missing 'type' attribute on positioning declaration. Must be one of: relative, absolute, layout");
        }
        Type type = Type.valueOf(typeString.toUpperCase(Locale.ROOT));
        String values = positioningElement.getTextContent().strip();
        if (!values.matches("-?\\d+,-?\\d+")) {
            throw new UIModelParsingException("Invalid value in positioning declaration");
        }
        int x = Integer.parseInt(values.split(",")[0]);
        int y = Integer.parseInt(values.split(",")[1]);
        return new Positioning(x, y, type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Positioning that = (Positioning)o;
        return this.x == that.x && this.y == that.y && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.x, this.y});
    }

    public static enum Type {
        RELATIVE,
        ABSOLUTE,
        LAYOUT;

    }
}

