/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.owostuff.ui.container;

import com.mojang.blaze3d.vertex.PoseStack;
import com.nyfaria.numismaticoverhaul.owostuff.ui.container.Containers;
import com.nyfaria.numismaticoverhaul.owostuff.ui.container.WrappingParentComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Color;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Easing;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Insets;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.ModComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Size;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Sizing;
import com.nyfaria.numismaticoverhaul.owostuff.ui.parsing.UIModel;
import com.nyfaria.numismaticoverhaul.owostuff.ui.parsing.UIModelParsingException;
import com.nyfaria.numismaticoverhaul.owostuff.ui.parsing.UIParsing;
import com.nyfaria.numismaticoverhaul.owostuff.ui.util.Drawer;
import com.nyfaria.numismaticoverhaul.owostuff.ui.util.NinePatchRenderer;
import com.nyfaria.numismaticoverhaul.owostuff.ui.util.OwoNinePatchRenderers;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;

public class ScrollContainer<C extends ModComponent>
extends WrappingParentComponent<C> {
    protected double scrollOffset = 0.0;
    protected double currentScrollPosition = 0.0;
    protected int lastScrollPosition = -1;
    protected int scrollStep = 0;
    protected int fixedScrollbarLength = 0;
    protected double lastScrollbarLength = 0.0;
    protected Scrollbar scrollbar = Scrollbar.flat(Color.ofArgb(-1610612736));
    protected int scrollbarThiccness = 3;
    protected long lastScrollbarInteractTime = 0L;
    protected int scrollbarOffset = 0;
    protected boolean scrollbaring = false;
    protected int maxScroll = 0;
    protected int childSize = 0;
    protected final ScrollDirection direction;

    protected ScrollContainer(ScrollDirection direction, Sizing horizontalSizing, Sizing verticalSizing, C child) {
        super(horizontalSizing, verticalSizing, child);
        this.direction = direction;
    }

    @Override
    protected void applyHorizontalContentSizing(Sizing sizing) {
        if (this.direction != ScrollDirection.VERTICAL) {
            throw new UnsupportedOperationException("Horizontal ScrollContainer cannot be horizontally content-sized");
        }
        super.applyHorizontalContentSizing(sizing);
    }

    @Override
    protected void applyVerticalContentSizing(Sizing sizing) {
        if (this.direction != ScrollDirection.HORIZONTAL) {
            throw new UnsupportedOperationException("Vertical ScrollContainer cannot be vertically content-sized");
        }
        super.applyVerticalContentSizing(sizing);
    }

    @Override
    public void layout(Size space) {
        super.layout(space);
        this.maxScroll = Math.max(0, this.direction.sizeGetter.apply(this.child) - (this.direction.sizeGetter.apply(this) - this.direction.insetGetter.apply((Insets)this.padding.get())));
        this.scrollOffset = Mth.m_14008_((double)this.scrollOffset, (double)0.0, (double)((double)this.maxScroll + 0.5));
        this.childSize = this.direction.sizeGetter.apply(this.child);
        this.lastScrollPosition = -1;
    }

    @Override
    protected int childMountX() {
        return (int)((double)super.childMountX() - this.direction.choose(this.currentScrollPosition, 0.0));
    }

    @Override
    protected int childMountY() {
        return (int)((double)super.childMountY() - this.direction.choose(0.0, this.currentScrollPosition));
    }

    @Override
    public void draw(PoseStack matrices, int mouseX, int mouseY, float partialTicks, float delta) {
        double scrollbarPosition;
        int newScrollPosition;
        int effectiveScrollOffset;
        super.draw(matrices, mouseX, mouseY, partialTicks, delta);
        this.currentScrollPosition += (this.scrollOffset - this.currentScrollPosition) * 0.5 * (double)delta;
        int n = effectiveScrollOffset = this.scrollStep > 0 ? (int)this.scrollOffset / this.scrollStep * this.scrollStep : (int)this.currentScrollPosition;
        if (this.scrollStep > 0 && (double)this.maxScroll - this.scrollOffset == -1.0) {
            effectiveScrollOffset = (int)((double)effectiveScrollOffset + this.scrollOffset % (double)this.scrollStep);
        }
        if ((newScrollPosition = this.direction.coordinateGetter.apply(this) - effectiveScrollOffset) != this.lastScrollPosition) {
            this.direction.coordinateSetter.accept(this.child, newScrollPosition + (this.direction == ScrollDirection.VERTICAL ? ((Insets)this.padding.get()).top() + ((Insets)this.child.margins().get()).top() : ((Insets)this.padding.get()).left() + ((Insets)this.child.margins().get()).left()));
            this.lastScrollPosition = newScrollPosition;
        }
        matrices.m_85836_();
        double visualOffset = -(this.currentScrollPosition % 1.0);
        if (visualOffset > 0.9999999 || visualOffset < 1.0E-7) {
            visualOffset = 0.0;
        }
        matrices.m_85837_(this.direction.choose(visualOffset, 0.0), this.direction.choose(0.0, visualOffset), 0.0);
        this.drawChildren(matrices, mouseX, mouseY, partialTicks, delta, Collections.singletonList(this.child));
        matrices.m_85849_();
        if (this.isInScrollbar(mouseX, mouseY) || this.scrollbaring) {
            this.lastScrollbarInteractTime = System.currentTimeMillis() + 1500L;
        }
        Insets padding = (Insets)this.padding.get();
        int selfSize = this.direction.sizeGetter.apply(this);
        int contentSize = this.direction.sizeGetter.apply(this) - this.direction.insetGetter.apply(padding);
        this.scrollbarOffset = this.direction == ScrollDirection.VERTICAL ? this.x + this.width - padding.right() - this.scrollbarThiccness : this.y + this.height - padding.bottom() - this.scrollbarThiccness;
        this.lastScrollbarLength = this.fixedScrollbarLength == 0 ? Math.min(Math.floor((float)selfSize / (float)this.childSize * (float)contentSize), (double)contentSize) : (double)this.fixedScrollbarLength;
        double d = scrollbarPosition = this.maxScroll != 0 ? this.currentScrollPosition / (double)this.maxScroll * ((double)contentSize - this.lastScrollbarLength) : 0.0;
        if (this.direction == ScrollDirection.VERTICAL) {
            this.scrollbar.draw(matrices, this.scrollbarOffset, (int)((double)this.y + scrollbarPosition + (double)padding.top()), this.scrollbarThiccness, (int)this.lastScrollbarLength, this.scrollbarOffset, this.y + padding.top(), this.scrollbarThiccness, this.height - padding.vertical(), this.lastScrollbarInteractTime, this.direction, this.maxScroll > 0);
        } else {
            this.scrollbar.draw(matrices, (int)((double)this.x + scrollbarPosition + (double)padding.left()), this.scrollbarOffset, (int)this.lastScrollbarLength, this.scrollbarThiccness, this.x + padding.left(), this.scrollbarOffset, this.width - padding.horizontal(), this.scrollbarThiccness, this.lastScrollbarInteractTime, this.direction, this.maxScroll > 0);
        }
    }

    @Override
    public boolean canFocus(ModComponent.FocusSource source) {
        return true;
    }

    @Override
    public boolean onMouseScroll(double mouseX, double mouseY, double amount) {
        if (this.child.onMouseScroll((double)this.x + mouseX - (double)this.child.x(), (double)this.y + mouseY - (double)this.child.y(), amount)) {
            return true;
        }
        if (this.scrollStep < 1) {
            this.scrollBy(-amount * 15.0, false, true);
        } else {
            this.scrollBy(-amount * (double)this.scrollStep, true, true);
        }
        return true;
    }

    @Override
    public boolean onMouseDown(double mouseX, double mouseY, int button) {
        if (this.isInScrollbar((double)this.x + mouseX, (double)this.y + mouseY)) {
            super.onMouseDown(mouseX, mouseY, button);
            return true;
        }
        return super.onMouseDown(mouseX, mouseY, button);
    }

    @Override
    public boolean onMouseDrag(double mouseX, double mouseY, double deltaX, double deltaY, int button) {
        if (!this.scrollbaring && !this.isInScrollbar((double)this.x + mouseX, (double)this.y + mouseY)) {
            return super.onMouseDrag(mouseX, mouseY, deltaX, deltaY, button);
        }
        double delta = this.direction.choose(deltaX, deltaY);
        double selfSize = this.direction.sizeGetter.apply(this) - this.direction.insetGetter.apply((Insets)this.padding.get());
        double scalar = (double)this.maxScroll / (selfSize - this.lastScrollbarLength);
        if (Double.isNaN(scalar)) {
            scalar = 0.0;
        }
        this.scrollBy(delta * scalar, true, false);
        this.scrollbaring = true;
        return true;
    }

    @Override
    public boolean onKeyPress(int keyCode, int scanCode, int modifiers) {
        if (keyCode == this.direction.lessKeycode) {
            this.scrollBy(-10.0, false, true);
        } else if (keyCode == this.direction.moreKeycode) {
            this.scrollBy(10.0, false, true);
        } else if (keyCode == 267) {
            this.scrollBy(this.direction.choose(this.width, this.height) * 0.8, false, true);
            this.lastScrollbarInteractTime = System.currentTimeMillis() + 1250L;
        } else if (keyCode == 266) {
            this.scrollBy(this.direction.choose(this.width, this.height) * -0.8, false, true);
        }
        return false;
    }

    @Override
    public boolean onMouseUp(double mouseX, double mouseY, int button) {
        this.scrollbaring = false;
        return true;
    }

    @Override
    @Nullable
    public ModComponent childAt(int x, int y) {
        if (this.isInScrollbar(x, y)) {
            return this;
        }
        return super.childAt(x, y);
    }

    protected void scrollBy(double offset, boolean instant, boolean showScrollbar) {
        this.scrollOffset = Mth.m_14008_((double)(this.scrollOffset + offset), (double)0.0, (double)((double)this.maxScroll + 0.5));
        if (instant) {
            this.currentScrollPosition = this.scrollOffset;
        }
        if (showScrollbar) {
            this.lastScrollbarInteractTime = System.currentTimeMillis() + 1250L;
        }
    }

    protected boolean isInScrollbar(double mouseX, double mouseY) {
        return this.isInBoundingBox(mouseX, mouseY) && this.direction.choose(mouseY, mouseX) >= (double)this.scrollbarOffset;
    }

    public ScrollContainer<C> scrollTo(ModComponent component) {
        this.scrollOffset = Mth.m_14008_((double)(this.scrollOffset - (double)(this.y - component.y() + ((Insets)component.margins().get()).top())), (double)0.0, (double)this.maxScroll);
        return this;
    }

    public ScrollContainer<C> scrollbarThiccness(int scrollbarThiccness) {
        this.scrollbarThiccness = scrollbarThiccness;
        return this;
    }

    public int scrollbarThiccness() {
        return this.scrollbarThiccness;
    }

    @Deprecated(forRemoval=true)
    public ScrollContainer<C> scrollbarColor(int scrollbarColor) {
        this.scrollbar(Scrollbar.flat(Color.ofArgb(scrollbarColor)));
        return this;
    }

    @Deprecated(forRemoval=true)
    public int scrollbarColor() {
        return 0;
    }

    public ScrollContainer<C> scrollbar(Scrollbar scrollbar) {
        this.scrollbar = scrollbar;
        return this;
    }

    public Scrollbar scrollbar() {
        return this.scrollbar;
    }

    public ScrollContainer<C> scrollStep(int scrollStep) {
        this.scrollStep = scrollStep;
        return this;
    }

    public int scrollStep() {
        return this.scrollStep;
    }

    public ScrollContainer<C> fixedScrollbarLength(int fixedScrollbarLength) {
        this.fixedScrollbarLength = fixedScrollbarLength;
        return this;
    }

    public int fixedScrollbarLength() {
        return this.fixedScrollbarLength;
    }

    @Override
    public void parseProperties(UIModel model, Element element, Map<String, Element> children) {
        super.parseProperties(model, element, children);
        UIParsing.apply(children, "fixed-scrollbar-length", UIParsing::parseUnsignedInt, this::fixedScrollbarLength);
        UIParsing.apply(children, "scrollbar-thiccness", UIParsing::parseUnsignedInt, this::scrollbarThiccness);
        UIParsing.apply(children, "scrollbar", Scrollbar::parse, this::scrollbar);
        UIParsing.apply(children, "scroll-step", UIParsing::parseUnsignedInt, this::scrollStep);
        UIParsing.apply(children, "scrollbar-color", Color::parseAndPack, integer -> {});
    }

    public static ScrollContainer<?> parse(Element element) {
        return element.getAttribute("direction").equals("vertical") ? Containers.verticalScroll(Sizing.content(), Sizing.content(), null) : Containers.horizontalScroll(Sizing.content(), Sizing.content(), null);
    }

    @FunctionalInterface
    public static interface Scrollbar {
        public static Scrollbar flat(Color color) {
            int scrollbarColor = color.argb();
            return (matrices, x, y, width, height, trackX, trackY, trackWidth, trackHeight, lastInteractTime, direction, active) -> {
                if (!active) {
                    return;
                }
                float progress = Easing.SINE.apply((float)Mth.m_14053_((long)(lastInteractTime - System.currentTimeMillis()), (long)0L, (long)750L) / 750.0f);
                int alpha = (int)(progress * (float)(scrollbarColor >>> 24));
                GuiComponent.m_93172_((PoseStack)matrices, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)(alpha << 24 | scrollbarColor & 0xFFFFFF));
            };
        }

        public static Scrollbar vanilla() {
            return (matrices, x, y, width, height, trackX, trackY, trackWidth, trackHeight, lastInteractTime, direction, active) -> {
                OwoNinePatchRenderers.VANILLA_SCROLLBAR_TRACK.draw(matrices, trackX, trackY, trackWidth, trackHeight);
                NinePatchRenderer renderer = direction == ScrollDirection.VERTICAL ? (active ? OwoNinePatchRenderers.VERTICAL_VANILLA_SCROLLBAR : OwoNinePatchRenderers.DISABLED_VERTICAL_VANILLA_SCROLLBAR) : (active ? OwoNinePatchRenderers.HORIZONTAL_VANILLA_SCROLLBAR : OwoNinePatchRenderers.DISABLED_HORIZONTAL_VANILLA_SCROLLBAR);
                renderer.draw(matrices, x + 1, y + 1, width - 2, height - 2);
            };
        }

        public static Scrollbar vanillaFlat() {
            return (matrices, x, y, width, height, trackX, trackY, trackWidth, trackHeight, lastInteractTime, direction, active) -> {
                Drawer.m_93172_((PoseStack)matrices, (int)trackX, (int)trackY, (int)(trackX + trackWidth), (int)(trackY + trackHeight), (int)Color.BLACK.argb());
                OwoNinePatchRenderers.FLAT_VANILLA_SCROLLBAR.draw(matrices, x, y, width, height);
            };
        }

        public void draw(PoseStack var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, long var10, ScrollDirection var12, boolean var13);

        public static Scrollbar parse(Element element) {
            List children = UIParsing.allChildrenOfType(element, (short)1);
            if (children.size() > 1) {
                throw new UIModelParsingException("'scrollbar' declaration may only contain a single child");
            }
            Element scrollbarElement = (Element)children.get(0);
            return switch (scrollbarElement.getNodeName()) {
                case "vanilla" -> Scrollbar.vanilla();
                case "vanilla-flat" -> Scrollbar.vanillaFlat();
                case "flat" -> Scrollbar.flat(Color.parse(scrollbarElement));
                default -> throw new UIModelParsingException("Unknown scrollbar type '" + scrollbarElement.getNodeName() + "'");
            };
        }
    }

    public static enum ScrollDirection {
        VERTICAL(ModComponent::height, ModComponent::setY, ModComponent::y, Insets::vertical, 265, 264),
        HORIZONTAL(ModComponent::width, ModComponent::setX, ModComponent::x, Insets::horizontal, 263, 262);

        public final Function<ModComponent, Integer> sizeGetter;
        public final BiConsumer<ModComponent, Integer> coordinateSetter;
        public final Function<ScrollContainer<?>, Integer> coordinateGetter;
        public final Function<Insets, Integer> insetGetter;
        public final int lessKeycode;
        public final int moreKeycode;

        private ScrollDirection(Function<ModComponent, Integer> sizeGetter, BiConsumer<ModComponent, Integer> coordinateSetter, Function<ScrollContainer<?>, Integer> coordinateGetter, Function<Insets, Integer> insetGetter, int lessKeycode, int moreKeycode) {
            this.sizeGetter = sizeGetter;
            this.coordinateSetter = coordinateSetter;
            this.coordinateGetter = coordinateGetter;
            this.insetGetter = insetGetter;
            this.lessKeycode = lessKeycode;
            this.moreKeycode = moreKeycode;
        }

        public double choose(double horizontal, double vertical) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case VERTICAL -> vertical;
                case HORIZONTAL -> horizontal;
            };
        }
    }
}

