/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.owostuff.ui.container;

import com.mojang.blaze3d.vertex.PoseStack;
import com.nyfaria.numismaticoverhaul.owostuff.ui.container.WrappingParentComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Insets;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.ModComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.ParentComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Sizing;
import com.nyfaria.numismaticoverhaul.owostuff.ui.parsing.UIModel;
import com.nyfaria.numismaticoverhaul.owostuff.ui.parsing.UIParsing;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;

public class DraggableContainer<C extends ModComponent>
extends WrappingParentComponent<C> {
    protected int foreheadSize = 10;
    protected boolean alwaysOnTop = false;
    protected int baseX = 0;
    protected int baseY = 0;
    protected double xOffset = 0.0;
    protected double yOffset = 0.0;

    protected DraggableContainer(Sizing horizontalSizing, Sizing verticalSizing, C child) {
        super(horizontalSizing, verticalSizing, child);
        this.padding(Insets.none());
    }

    @Override
    public void draw(PoseStack matrices, int mouseX, int mouseY, float partialTicks, float delta) {
        if (this.alwaysOnTop) {
            matrices.m_85837_(0.0, 0.0, 500.0);
        }
        super.draw(matrices, mouseX, mouseY, partialTicks, delta);
        this.drawChildren(matrices, mouseX, mouseY, partialTicks, delta, Collections.singletonList(this.child));
        if (this.alwaysOnTop) {
            matrices.m_85837_(0.0, 0.0, -500.0);
        }
    }

    @Override
    public void drawTooltip(PoseStack matrices, int mouseX, int mouseY, float partialTicks, float delta) {
        if (this.alwaysOnTop) {
            matrices.m_85837_(0.0, 0.0, 500.0);
        }
        super.drawTooltip(matrices, mouseX, mouseY, partialTicks, delta);
        if (this.alwaysOnTop) {
            matrices.m_85837_(0.0, 0.0, -500.0);
        }
    }

    @Override
    public boolean canFocus(ModComponent.FocusSource source) {
        return source == ModComponent.FocusSource.MOUSE_CLICK;
    }

    @Override
    public boolean onMouseDrag(double mouseX, double mouseY, double deltaX, double deltaY, int button) {
        this.xOffset += deltaX;
        this.yOffset += deltaY;
        super.setX((int)((long)this.baseX + Math.round(this.xOffset)));
        super.setY((int)((long)this.baseY + Math.round(this.yOffset)));
        return super.onMouseDrag(mouseX, mouseY, deltaX, deltaY, button);
    }

    @Override
    @Nullable
    public ModComponent childAt(int x, int y) {
        if (this.isInBoundingBox(x, y) && y - this.y < this.foreheadSize) {
            return this;
        }
        return super.childAt(x, y);
    }

    @Override
    public void setX(int x) {
        this.baseX = x;
        super.setX((int)((long)x + Math.round(this.xOffset)));
    }

    @Override
    public void setY(int y) {
        this.baseY = y;
        super.setY((int)((long)y + Math.round(this.yOffset)));
    }

    @Override
    public ParentComponent padding(Insets padding) {
        return super.padding(Insets.of(padding.top() + this.foreheadSize, padding.bottom(), padding.left(), padding.right()));
    }

    public DraggableContainer<C> foreheadSize(int foreheadSize) {
        int prevForeheadSize = this.foreheadSize;
        this.foreheadSize = foreheadSize;
        Insets padding = (Insets)this.padding.get();
        this.padding(Insets.of(padding.top() - prevForeheadSize, padding.bottom(), padding.left(), padding.right()));
        return this;
    }

    public int foreheadSize() {
        return this.foreheadSize;
    }

    public DraggableContainer<C> alwaysOnTop(boolean alwaysOnTop) {
        this.alwaysOnTop = alwaysOnTop;
        return this;
    }

    public boolean alwaysOnTop() {
        return this.alwaysOnTop;
    }

    @Override
    public void parseProperties(UIModel model, Element element, Map<String, Element> children) {
        super.parseProperties(model, element, children);
        UIParsing.apply(children, "forehead-size", UIParsing::parseUnsignedInt, this::foreheadSize);
        UIParsing.apply(children, "always-on-top", UIParsing::parseBool, this::alwaysOnTop);
    }
}

