/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.owostuff.ui.container;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.nyfaria.numismaticoverhaul.owostuff.ui.component.Components;
import com.nyfaria.numismaticoverhaul.owostuff.ui.component.LabelComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.container.Containers;
import com.nyfaria.numismaticoverhaul.owostuff.ui.container.FlowLayout;
import com.nyfaria.numismaticoverhaul.owostuff.ui.container.VerticalFlowLayout;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.CursorStyle;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Insets;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.ModComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Sizing;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Surface;
import com.nyfaria.numismaticoverhaul.owostuff.ui.parsing.UIParsing;
import com.nyfaria.numismaticoverhaul.owostuff.ui.util.Drawer;
import com.nyfaria.numismaticoverhaul.owostuff.ui.util.UISounds;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.w3c.dom.Element;

public class CollapsibleContainer
extends VerticalFlowLayout {
    public static final Surface SURFACE = (matrices, component) -> Drawer.m_93172_((PoseStack)matrices, (int)(component.x() + 5), (int)component.y(), (int)(component.x() + 6), (int)(component.y() + component.height()), (int)0x77FFFFFF);
    protected List<ModComponent> collapsibleChildren = new ArrayList<ModComponent>();
    protected boolean expanded;
    protected final SpinnyBoiComponent spinnyBoi;
    protected final FlowLayout titleLayout;

    protected CollapsibleContainer(Sizing horizontalSizing, Sizing verticalSizing, Component title, boolean expanded) {
        super(horizontalSizing, verticalSizing);
        this.surface(SURFACE);
        this.padding(Insets.left(15));
        this.titleLayout = Containers.horizontalFlow(Sizing.content(), Sizing.content());
        this.titleLayout.padding(Insets.vertical(5));
        this.titleLayout.margins(Insets.left(-7));
        this.allowOverflow(true);
        this.spinnyBoi = new SpinnyBoiComponent();
        this.titleLayout.child(this.spinnyBoi);
        title = title.m_6881_().m_130940_(ChatFormatting.UNDERLINE);
        this.titleLayout.child(Components.label(title).cursorStyle(CursorStyle.HAND));
        this.expanded = expanded;
        this.spinnyBoi.rotation = this.spinnyBoi.targetRotation = expanded ? 90.0f : 0.0f;
        super.child(this.titleLayout);
    }

    protected void toggleExpansion() {
        if (this.expanded) {
            this.children.removeAll(this.collapsibleChildren);
            this.spinnyBoi.targetRotation = 0.0f;
        } else {
            this.children.addAll(this.collapsibleChildren);
            this.spinnyBoi.targetRotation = 90.0f;
        }
        this.updateLayout();
        this.expanded = !this.expanded;
    }

    @Override
    public boolean canFocus(ModComponent.FocusSource source) {
        return source == ModComponent.FocusSource.KEYBOARD_CYCLE;
    }

    @Override
    public boolean onKeyPress(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 32 || keyCode == 257 || keyCode == 335) {
            this.toggleExpansion();
            super.onKeyPress(keyCode, scanCode, modifiers);
            return true;
        }
        return super.onKeyPress(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean onMouseDown(double mouseX, double mouseY, int button) {
        boolean superResult = super.onMouseDown(mouseX, mouseY, button);
        if (mouseY <= (double)this.titleLayout.fullSize().height() && !superResult) {
            this.toggleExpansion();
            UISounds.playInteractionSound();
            return true;
        }
        return superResult;
    }

    @Override
    public FlowLayout child(ModComponent child) {
        this.collapsibleChildren.add(child);
        if (this.expanded) {
            super.child(child);
        }
        return this;
    }

    @Override
    public FlowLayout children(Collection<ModComponent> children) {
        this.collapsibleChildren.addAll(children);
        if (this.expanded) {
            super.children(children);
        }
        return this;
    }

    @Override
    public FlowLayout child(int index, ModComponent child) {
        this.collapsibleChildren.add(index, child);
        if (this.expanded) {
            super.child(index + this.children.size() - this.collapsibleChildren.size(), child);
        }
        return this;
    }

    @Override
    public FlowLayout children(int index, Collection<ModComponent> children) {
        this.collapsibleChildren.addAll(index, children);
        if (this.expanded) {
            super.children(index + this.children.size() - this.collapsibleChildren.size(), children);
        }
        return this;
    }

    @Override
    public FlowLayout removeChild(ModComponent child) {
        this.collapsibleChildren.remove(child);
        return super.removeChild(child);
    }

    public static CollapsibleContainer parse(Element element) {
        Element textElement = UIParsing.childElements(element).get("text");
        MutableComponent title = textElement == null ? Component.m_237119_() : UIParsing.parseText(textElement);
        return element.getAttribute("expanded").equals("true") ? Containers.collapsible(Sizing.content(), Sizing.content(), (Component)title, true) : Containers.collapsible(Sizing.content(), Sizing.content(), (Component)title, false);
    }

    protected static class SpinnyBoiComponent
    extends LabelComponent {
        protected float rotation = 90.0f;
        protected float targetRotation = 90.0f;

        public SpinnyBoiComponent() {
            super((Component)Component.m_237113_((String)">"));
            this.margins(Insets.horizontal(4));
        }

        @Override
        public void update(float delta, int mouseX, int mouseY) {
            super.update(delta, mouseX, mouseY);
            this.rotation = (float)((double)this.rotation + (double)((this.targetRotation - this.rotation) * delta) * 0.65);
        }

        @Override
        public void draw(PoseStack matrices, int mouseX, int mouseY, float partialTicks, float delta) {
            matrices.m_85836_();
            matrices.m_85837_((double)((float)this.x + (float)this.width / 2.0f - 1.0f), (double)((float)this.y + (float)this.height / 2.0f - 1.0f), 0.0);
            matrices.m_85845_(Vector3f.f_122227_.m_122240_(this.rotation));
            matrices.m_85837_((double)(-((float)this.x + (float)this.width / 2.0f - 1.0f)), (double)(-((float)this.y + (float)this.height / 2.0f - 1.0f)), 0.0);
            super.draw(matrices, mouseX, mouseY, partialTicks, delta);
            matrices.m_85849_();
        }
    }
}

