/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.owostuff.ui.component;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.nyfaria.numismaticoverhaul.owostuff.ui.base.BaseComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.ModComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Sizing;
import com.nyfaria.numismaticoverhaul.owostuff.ui.parsing.UIModel;
import com.nyfaria.numismaticoverhaul.owostuff.ui.parsing.UIModelParsingException;
import com.nyfaria.numismaticoverhaul.owostuff.ui.parsing.UIParsing;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;

public class EntityComponent<E extends Entity>
extends BaseComponent {
    protected final EntityRenderDispatcher dispatcher;
    protected final MultiBufferSource.BufferSource entityBuffers;
    protected final E entity;
    protected float mouseRotation = 0.0f;
    protected float scale = 1.0f;
    protected boolean lookAtCursor = false;
    protected boolean allowMouseRotation = false;
    protected boolean scaleToFit = false;

    protected EntityComponent(Sizing sizing, E entity) {
        Minecraft client = Minecraft.m_91087_();
        this.dispatcher = client.m_91290_();
        this.entityBuffers = client.m_91269_().m_110104_();
        this.entity = entity;
        this.sizing(sizing);
    }

    protected EntityComponent(Sizing sizing, EntityType<E> type, @Nullable CompoundTag nbt) {
        Minecraft client = Minecraft.m_91087_();
        this.dispatcher = client.m_91290_();
        this.entityBuffers = client.m_91269_().m_110104_();
        this.entity = type.m_20615_((Level)client.f_91073_);
        if (nbt != null) {
            this.entity.m_20258_(nbt);
        }
        this.entity.m_20248_(client.f_91074_.m_20185_(), client.f_91074_.m_20186_(), client.f_91074_.m_20189_());
        this.sizing(sizing);
    }

    @Override
    public void draw(PoseStack matrices, int mouseX, int mouseY, float partialTicks, float delta) {
        matrices.m_85836_();
        matrices.m_85837_((double)((float)this.x + (float)this.width / 2.0f), (double)((float)this.y + (float)this.height / 2.0f), 100.0);
        matrices.m_85841_(75.0f * this.scale * (float)this.width / 64.0f, -75.0f * this.scale * (float)this.height / 64.0f, 75.0f * this.scale);
        matrices.m_85837_(0.0, (double)(this.entity.m_20206_() / -2.0f), 0.0);
        if (this.lookAtCursor) {
            float xRotation = (float)Math.toDegrees(Math.atan(((float)(mouseY - this.y) - (float)this.height / 2.0f) / 40.0f));
            float yRotation = (float)Math.toDegrees(Math.atan(((float)(mouseX - this.x) - (float)this.width / 2.0f) / 40.0f));
            E e = this.entity;
            if (e instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)e;
                living.f_20886_ = -yRotation;
            }
            ((Entity)this.entity).f_19859_ = -yRotation;
            ((Entity)this.entity).f_19860_ = xRotation * 0.65f;
            if (xRotation == 0.0f) {
                xRotation = 0.1f;
            }
            matrices.m_85845_(Vector3f.f_122223_.m_122240_(xRotation * 0.15f));
            matrices.m_85845_(Vector3f.f_122225_.m_122240_(yRotation * 0.15f));
        } else {
            matrices.m_85845_(Vector3f.f_122223_.m_122240_(35.0f));
            matrices.m_85845_(Vector3f.f_122225_.m_122240_(-45.0f + this.mouseRotation));
        }
        RenderSystem.m_157450_((Vector3f)new Vector3f(0.15f, 1.0f, 0.0f), (Vector3f)new Vector3f(0.15f, -1.0f, 0.0f));
        this.dispatcher.m_114468_(false);
        this.dispatcher.m_114384_(this.entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, matrices, (MultiBufferSource)this.entityBuffers, 0xF000F0);
        this.dispatcher.m_114468_(true);
        this.entityBuffers.m_109911_();
        Lighting.m_84931_();
        matrices.m_85849_();
    }

    @Override
    public boolean onMouseDrag(double mouseX, double mouseY, double deltaX, double deltaY, int button) {
        if (this.allowMouseRotation && button == 0) {
            this.mouseRotation = (float)((double)this.mouseRotation + deltaX);
            super.onMouseDrag(mouseX, mouseY, deltaX, deltaY, button);
            return true;
        }
        return super.onMouseDrag(mouseX, mouseY, deltaX, deltaY, button);
    }

    public E entity() {
        return this.entity;
    }

    public EntityComponent<E> allowMouseRotation(boolean allowMouseRotation) {
        this.allowMouseRotation = allowMouseRotation;
        return this;
    }

    public boolean allowMouseRotation() {
        return this.allowMouseRotation;
    }

    public EntityComponent<E> lookAtCursor(boolean lookAtCursor) {
        this.lookAtCursor = lookAtCursor;
        return this;
    }

    public boolean lookAtCursor() {
        return this.lookAtCursor;
    }

    public EntityComponent<E> scale(float scale) {
        this.scale = scale;
        return this;
    }

    public float scale() {
        return this.scale;
    }

    public EntityComponent<E> scaleToFit(boolean scaleToFit) {
        this.scaleToFit = scaleToFit;
        if (scaleToFit) {
            float xScale = 0.5f / this.entity.m_20205_();
            float yScale = 0.5f / this.entity.m_20206_();
            this.scale(Math.min(xScale, yScale));
        }
        return this;
    }

    public boolean scaleToFit() {
        return this.scaleToFit;
    }

    @Override
    public boolean canFocus(ModComponent.FocusSource source) {
        return source == ModComponent.FocusSource.MOUSE_CLICK;
    }

    public static RenderablePlayerEntity createRenderablePlayer(GameProfile profile) {
        return new RenderablePlayerEntity(profile);
    }

    @Override
    public void parseProperties(UIModel model, Element element, Map<String, Element> children) {
        super.parseProperties(model, element, children);
        UIParsing.apply(children, "scale", UIParsing::parseFloat, this::scale);
        UIParsing.apply(children, "look-at-cursor", UIParsing::parseBool, this::lookAtCursor);
        UIParsing.apply(children, "mouse-rotation", UIParsing::parseBool, this::allowMouseRotation);
        UIParsing.apply(children, "scale-to-fit", UIParsing::parseBool, this::scaleToFit);
    }

    public static EntityComponent<?> parse(Element element) {
        UIParsing.expectAttributes(element, "type");
        ResourceLocation entityId = UIParsing.parseIdentifier(element.getAttributeNode("type"));
        EntityType entityType = (EntityType)Registry.f_122826_.m_6612_(entityId).orElseThrow(() -> new UIModelParsingException("Unknown entity type " + entityId));
        return new EntityComponent(Sizing.content(), entityType, null);
    }

    protected static class RenderablePlayerEntity
    extends LocalPlayer {
        protected ResourceLocation skinTextureId = null;
        protected String model = null;

        public RenderablePlayerEntity(GameProfile profile) {
            super(Minecraft.m_91087_(), Minecraft.m_91087_().f_91073_, new ClientPacketListener(Minecraft.m_91087_(), null, new Connection(PacketFlow.CLIENTBOUND), profile, Minecraft.m_91087_().m_193590_()), null, null, false, false);
            this.f_108619_.m_91109_().m_118817_(this.m_36316_(), (type, identifier, texture) -> {
                if (type != MinecraftProfileTexture.Type.SKIN) {
                    return;
                }
                this.skinTextureId = identifier;
                this.model = texture.getMetadata("model");
                if (this.model == null) {
                    this.model = "default";
                }
            }, true);
        }

        public boolean m_108559_() {
            return this.skinTextureId != null;
        }

        public ResourceLocation m_108560_() {
            return this.skinTextureId != null ? this.skinTextureId : super.m_108560_();
        }

        public boolean m_36170_(PlayerModelPart modelPart) {
            return true;
        }

        public String m_108564_() {
            return this.model != null ? this.model : super.m_108564_();
        }

        @Nullable
        protected PlayerInfo m_108558_() {
            return null;
        }
    }
}

