/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.owostuff.ui.component;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.nyfaria.numismaticoverhaul.owostuff.ui.component.Components;
import com.nyfaria.numismaticoverhaul.owostuff.ui.component.VanillaWidgetComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.AnimatableProperty;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Color;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.CursorStyle;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Insets;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.ModComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.ParentComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Positioning;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Size;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Sizing;
import com.nyfaria.numismaticoverhaul.owostuff.ui.event.CharTyped;
import com.nyfaria.numismaticoverhaul.owostuff.ui.event.FocusGained;
import com.nyfaria.numismaticoverhaul.owostuff.ui.event.FocusLost;
import com.nyfaria.numismaticoverhaul.owostuff.ui.event.KeyPress;
import com.nyfaria.numismaticoverhaul.owostuff.ui.event.MouseDown;
import com.nyfaria.numismaticoverhaul.owostuff.ui.event.MouseDrag;
import com.nyfaria.numismaticoverhaul.owostuff.ui.event.MouseEnter;
import com.nyfaria.numismaticoverhaul.owostuff.ui.event.MouseLeave;
import com.nyfaria.numismaticoverhaul.owostuff.ui.event.MouseScroll;
import com.nyfaria.numismaticoverhaul.owostuff.ui.event.MouseUp;
import com.nyfaria.numismaticoverhaul.owostuff.ui.inject.ButtonWidgetExtension;
import com.nyfaria.numismaticoverhaul.owostuff.ui.parsing.UIModel;
import com.nyfaria.numismaticoverhaul.owostuff.ui.parsing.UIModelParsingException;
import com.nyfaria.numismaticoverhaul.owostuff.ui.parsing.UIParsing;
import com.nyfaria.numismaticoverhaul.owostuff.ui.util.Drawer;
import com.nyfaria.numismaticoverhaul.owostuff.ui.util.FocusHandler;
import com.nyfaria.numismaticoverhaul.owostuff.ui.util.OwoNinePatchRenderers;
import com.nyfaria.numismaticoverhaul.owostuff.util.EventSource;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;

public class ButtonComponent
extends Button
implements ModComponent,
ButtonWidgetExtension {
    protected Renderer renderer = Renderer.VANILLA;
    protected boolean textShadow = true;
    protected VanillaWidgetComponent owo$wrapper = null;
    protected CursorStyle preferredCursorStyle = CursorStyle.POINTER;

    protected ButtonComponent(Component message, Consumer<ButtonComponent> onPress) {
        super(0, 0, 0, 0, message, button -> onPress.accept((ButtonComponent)button));
    }

    public void m_6303_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        int color;
        this.renderer.draw(matrices, this, delta);
        Font textRenderer = Minecraft.m_91087_().f_91062_;
        int n = color = this.f_93623_ ? 0xFFFFFF : 0xA0A0A0;
        if (this.textShadow) {
            Drawer.m_93215_((PoseStack)matrices, (Font)textRenderer, (Component)this.m_6035_(), (int)(this.f_93620_ + this.f_93618_ / 2), (int)(this.f_93621_ + (this.f_93619_ - 8) / 2), (int)color);
        } else {
            textRenderer.m_92889_(matrices, this.m_6035_(), (float)this.f_93620_ + (float)this.f_93618_ / 2.0f - (float)textRenderer.m_92852_((FormattedText)this.m_6035_()) / 2.0f, (float)this.f_93621_ + (float)(this.f_93619_ - 8) / 2.0f, color);
        }
        if (this.f_93622_) {
            this.m_7428_(matrices, mouseX, mouseY);
        }
    }

    public ButtonComponent onPress(Consumer<ButtonComponent> onPress) {
        this.onPress(button -> onPress.accept((ButtonComponent)button));
        return this;
    }

    public ButtonComponent renderer(Renderer renderer) {
        this.renderer = renderer;
        return this;
    }

    public Renderer renderer() {
        return this.renderer;
    }

    public ButtonComponent textShadow(boolean textShadow) {
        this.textShadow = textShadow;
        return this;
    }

    public boolean textShadow() {
        return this.textShadow;
    }

    @Override
    public void parseProperties(UIModel model, Element element, Map<String, Element> children) {
        this.superparseProperties(model, element, children);
        UIParsing.apply(children, "text", UIParsing::parseText, arg_0 -> ((ButtonComponent)this).m_93666_(arg_0));
        UIParsing.apply(children, "text-shadow", UIParsing::parseBool, this::textShadow);
        UIParsing.apply(children, "renderer", Renderer::parse, this::renderer);
    }

    protected CursorStyle owo$preferredCursorStyle() {
        return CursorStyle.HAND;
    }

    @Override
    public void inflate(Size space) {
        this.owo$getWrapper().inflate(space);
    }

    @Override
    public void mount(ParentComponent parent, int x, int y) {
        this.owo$getWrapper().mount(parent, x, y);
    }

    @Override
    public void dismount(ModComponent.DismountReason reason) {
        this.owo$getWrapper().dismount(reason);
    }

    @Override
    @Nullable
    public ParentComponent parent() {
        return this.owo$getWrapper().parent();
    }

    @Override
    @Nullable
    public FocusHandler focusHandler() {
        return this.owo$getWrapper().focusHandler();
    }

    @Override
    public ModComponent positioning(Positioning positioning) {
        this.owo$getWrapper().positioning(positioning);
        return this;
    }

    @Override
    public AnimatableProperty<Positioning> positioning() {
        return this.owo$getWrapper().positioning();
    }

    @Override
    public ModComponent margins(Insets margins) {
        this.owo$getWrapper().margins(margins);
        return this;
    }

    @Override
    public AnimatableProperty<Insets> margins() {
        return this.owo$getWrapper().margins();
    }

    @Override
    public ModComponent horizontalSizing(Sizing horizontalSizing) {
        this.owo$getWrapper().horizontalSizing(horizontalSizing);
        return this;
    }

    @Override
    public ModComponent verticalSizing(Sizing verticalSizing) {
        this.owo$getWrapper().verticalSizing(verticalSizing);
        return this;
    }

    @Override
    public AnimatableProperty<Sizing> horizontalSizing() {
        return this.owo$getWrapper().horizontalSizing();
    }

    @Override
    public AnimatableProperty<Sizing> verticalSizing() {
        return this.owo$getWrapper().horizontalSizing();
    }

    @Override
    public EventSource<MouseDown> mouseDown() {
        return this.owo$getWrapper().mouseDown();
    }

    @Override
    public int x() {
        return this.owo$getWrapper().x();
    }

    @Override
    public void setX(int x) {
        this.owo$getWrapper().setX(x);
    }

    @Override
    public int y() {
        return this.owo$getWrapper().y();
    }

    @Override
    public void setY(int y) {
        this.owo$getWrapper().setY(y);
    }

    @Override
    public int width() {
        return this.owo$getWrapper().width();
    }

    @Override
    public int height() {
        return this.owo$getWrapper().height();
    }

    @Override
    public void draw(PoseStack matrices, int mouseX, int mouseY, float partialTicks, float delta) {
        this.owo$getWrapper().draw(matrices, mouseX, mouseY, partialTicks, delta);
    }

    @Override
    public void update(float delta, int mouseX, int mouseY) {
        this.owo$getWrapper().update(delta, mouseX, mouseY);
        this.cursorStyle(this.f_93623_ ? this.owo$preferredCursorStyle() : CursorStyle.POINTER);
    }

    @Override
    public boolean onMouseDown(double mouseX, double mouseY, int button) {
        return this.owo$getWrapper().onMouseDown(mouseX, mouseY, button);
    }

    @Override
    public boolean onMouseUp(double mouseX, double mouseY, int button) {
        return this.owo$getWrapper().onMouseUp(mouseX, mouseY, button);
    }

    @Override
    public EventSource<MouseUp> mouseUp() {
        return this.owo$getWrapper().mouseUp();
    }

    @Override
    public EventSource<MouseScroll> mouseScroll() {
        return this.owo$getWrapper().mouseScroll();
    }

    @Override
    public EventSource<MouseDrag> mouseDrag() {
        return this.owo$getWrapper().mouseDrag();
    }

    @Override
    public EventSource<KeyPress> keyPress() {
        return this.owo$getWrapper().keyPress();
    }

    @Override
    public EventSource<CharTyped> charTyped() {
        return this.owo$getWrapper().charTyped();
    }

    @Override
    public EventSource<FocusGained> focusGained() {
        return this.owo$getWrapper().focusGained();
    }

    @Override
    public EventSource<FocusLost> focusLost() {
        return this.owo$getWrapper().focusLost();
    }

    @Override
    public EventSource<MouseEnter> mouseEnter() {
        return this.owo$getWrapper().mouseEnter();
    }

    @Override
    public EventSource<MouseLeave> mouseLeave() {
        return this.owo$getWrapper().mouseLeave();
    }

    @Override
    public boolean onMouseScroll(double mouseX, double mouseY, double amount) {
        return this.owo$getWrapper().onMouseScroll(mouseX, mouseY, amount);
    }

    @Override
    public boolean onMouseDrag(double mouseX, double mouseY, double deltaX, double deltaY, int button) {
        return this.owo$getWrapper().onMouseDrag(mouseX, mouseY, deltaX, deltaY, button);
    }

    @Override
    public boolean onKeyPress(int keyCode, int scanCode, int modifiers) {
        return this.owo$getWrapper().onKeyPress(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean onCharTyped(char chr, int modifiers) {
        return this.owo$getWrapper().onCharTyped(chr, modifiers);
    }

    @Override
    public boolean canFocus(ModComponent.FocusSource source) {
        return true;
    }

    @Override
    public void onFocusGained(ModComponent.FocusSource source) {
        this.m_93692_(source == ModComponent.FocusSource.KEYBOARD_CYCLE);
        this.owo$getWrapper().onFocusGained(source);
    }

    @Override
    public void onFocusLost() {
        this.m_93692_(false);
        this.owo$getWrapper().onFocusLost();
    }

    public void superparseProperties(UIModel spec, Element element, Map<String, Element> children) {
        if (!element.getAttribute("id").isBlank()) {
            this.id(element.getAttribute("id").strip());
        }
        UIParsing.apply(children, "margins", Insets::parse, this::margins);
        UIParsing.apply(children, "positioning", Positioning::parse, this::positioning);
        UIParsing.apply(children, "z-index", UIParsing::parseSignedInt, this::zIndex);
        UIParsing.apply(children, "cursor-style", UIParsing.parseEnum(CursorStyle.class), this::cursorStyle);
        UIParsing.apply(children, "tooltip-text", UIParsing::parseText, this::tooltip);
        if (children.containsKey("sizing")) {
            Map<String, Element> sizingValues = UIParsing.childElements(children.get("sizing"));
            UIParsing.apply(sizingValues, "vertical", Sizing::parse, this::verticalSizing);
            UIParsing.apply(sizingValues, "horizontal", Sizing::parse, this::horizontalSizing);
        }
        UIParsing.apply(children, "active", UIParsing::parseBool, active -> {
            this.f_93623_ = active;
        });
    }

    @Override
    public CursorStyle cursorStyle() {
        return this.owo$getWrapper().cursorStyle();
    }

    @Override
    public ModComponent cursorStyle(CursorStyle style) {
        return this.owo$getWrapper().cursorStyle(style);
    }

    @Override
    public ModComponent tooltip(List<ClientTooltipComponent> tooltip) {
        return this.owo$getWrapper().tooltip(tooltip);
    }

    @Override
    public List<ClientTooltipComponent> tooltip() {
        return this.owo$getWrapper().tooltip();
    }

    @Override
    public ModComponent zIndex(int zIndex) {
        return this.owo$getWrapper().zIndex(zIndex);
    }

    @Override
    public int zIndex() {
        return this.owo$getWrapper().zIndex();
    }

    @Override
    public ModComponent id(@Nullable String id) {
        this.owo$getWrapper().id(id);
        return this;
    }

    @Override
    @Nullable
    public String id() {
        return this.owo$getWrapper().id();
    }

    protected VanillaWidgetComponent owo$getWrapper() {
        if (this.owo$wrapper == null) {
            this.owo$wrapper = Components.wrapVanillaWidget((AbstractWidget)this);
        }
        return this.owo$wrapper;
    }

    @FunctionalInterface
    public static interface Renderer {
        public static final Renderer VANILLA = (matrices, button, delta) -> {
            if (button.f_93623_) {
                if (button.f_93622_) {
                    OwoNinePatchRenderers.HOVERED_BUTTON.draw(matrices, button.f_93620_, button.f_93621_, button.f_93618_, button.f_93619_);
                } else {
                    OwoNinePatchRenderers.ACTIVE_BUTTON.draw(matrices, button.f_93620_, button.f_93621_, button.f_93618_, button.f_93619_);
                }
            } else {
                OwoNinePatchRenderers.BUTTON_DISABLED.draw(matrices, button.f_93620_, button.f_93621_, button.f_93618_, button.f_93619_);
            }
        };

        public static Renderer flat(int color, int hoveredColor, int disabledColor) {
            return (matrices, button, delta) -> {
                if (button.f_93623_) {
                    if (button.f_93622_) {
                        Drawer.m_93172_((PoseStack)matrices, (int)button.f_93620_, (int)button.f_93621_, (int)(button.f_93620_ + button.f_93618_), (int)(button.f_93621_ + button.f_93619_), (int)hoveredColor);
                    } else {
                        Drawer.m_93172_((PoseStack)matrices, (int)button.f_93620_, (int)button.f_93621_, (int)(button.f_93620_ + button.f_93618_), (int)(button.f_93621_ + button.f_93619_), (int)color);
                    }
                } else {
                    Drawer.m_93172_((PoseStack)matrices, (int)button.f_93620_, (int)button.f_93621_, (int)(button.f_93620_ + button.f_93618_), (int)(button.f_93621_ + button.f_93619_), (int)disabledColor);
                }
            };
        }

        public static Renderer texture(ResourceLocation texture, int u, int v, int textureWidth, int textureHeight) {
            return (matrices, button, delta) -> {
                int renderV = v;
                if (!button.f_93623_) {
                    renderV += button.f_93619_ * 2;
                } else if (button.m_198029_()) {
                    renderV += button.f_93619_;
                }
                RenderSystem.m_69482_();
                RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
                Drawer.m_93133_((PoseStack)matrices, (int)button.f_93620_, (int)button.f_93621_, (float)u, (float)renderV, (int)button.f_93618_, (int)button.f_93619_, (int)textureWidth, (int)textureHeight);
            };
        }

        public void draw(PoseStack var1, ButtonComponent var2, float var3);

        public static Renderer parse(Element element) {
            List children = UIParsing.allChildrenOfType(element, (short)1);
            if (children.size() > 1) {
                throw new UIModelParsingException("'renderer' declaration may only contain a single child");
            }
            Element rendererElement = (Element)children.get(0);
            return switch (rendererElement.getNodeName()) {
                case "vanilla" -> VANILLA;
                case "flat" -> {
                    UIParsing.expectAttributes(rendererElement, "color", "hovered-color", "disabled-color");
                    yield Renderer.flat(Color.parseAndPack(rendererElement.getAttributeNode("color")), Color.parseAndPack(rendererElement.getAttributeNode("hovered-color")), Color.parseAndPack(rendererElement.getAttributeNode("disabled-color")));
                }
                case "texture" -> {
                    UIParsing.expectAttributes(rendererElement, "texture", "u", "v", "texture-width", "texture-height");
                    yield Renderer.texture(UIParsing.parseIdentifier(rendererElement.getAttributeNode("texture")), UIParsing.parseUnsignedInt(rendererElement.getAttributeNode("u")), UIParsing.parseUnsignedInt(rendererElement.getAttributeNode("v")), UIParsing.parseUnsignedInt(rendererElement.getAttributeNode("texture-width")), UIParsing.parseUnsignedInt(rendererElement.getAttributeNode("texture-height")));
                }
                default -> throw new UIModelParsingException("Unknown button renderer '" + rendererElement.getNodeName() + "'");
            };
        }
    }
}

