/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.owostuff.ui.base;

import com.mojang.blaze3d.vertex.PoseStack;
import com.nyfaria.numismaticoverhaul.mixin.owomixins.ui.SlotAccessor;
import com.nyfaria.numismaticoverhaul.owostuff.ui.base.BaseComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.ModComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.OwoUIAdapter;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.ParentComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.PositionedRectangle;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Sizing;
import com.nyfaria.numismaticoverhaul.owostuff.ui.inject.GreedyInputComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.util.Drawer;
import com.nyfaria.numismaticoverhaul.owostuff.ui.util.UIErrorToast;
import com.nyfaria.numismaticoverhaul.owostuff.util.pond.OwoSlotExtension;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public abstract class BaseOwoHandledScreen<R extends ParentComponent, S extends AbstractContainerMenu>
extends AbstractContainerScreen<S> {
    protected OwoUIAdapter<R> uiAdapter = null;
    protected boolean invalid = false;

    protected BaseOwoHandledScreen(S handler, Inventory inventory, Component title) {
        super(handler, inventory, title);
    }

    @NotNull
    protected abstract OwoUIAdapter<R> createAdapter();

    protected abstract void build(R var1);

    protected void m_7856_() {
        super.m_7856_();
        if (this.invalid) {
            return;
        }
        if (this.uiAdapter != null) {
            this.uiAdapter.moveAndResize(0, 0, this.f_96543_, this.f_96544_);
            this.m_142416_(this.uiAdapter);
        } else {
            try {
                this.uiAdapter = this.createAdapter();
                this.build(this.uiAdapter.rootComponent);
                this.uiAdapter.inflateAndMount();
                this.f_96541_.f_91068_.m_90926_(true);
            }
            catch (Exception error) {
                UIErrorToast.report(error);
                this.invalid = true;
            }
        }
    }

    protected void disableSlot(int index) {
        ((OwoSlotExtension)this.f_97732_.f_38839_.get(index)).owo$setDisabledOverride(true);
    }

    protected void disableSlot(Slot slot) {
        ((OwoSlotExtension)slot).owo$setDisabledOverride(true);
    }

    protected void enableSlot(int index) {
        ((OwoSlotExtension)this.f_97732_.f_38839_.get(index)).owo$setDisabledOverride(false);
    }

    protected void enableSlot(Slot slot) {
        ((OwoSlotExtension)slot).owo$setDisabledOverride(true);
    }

    protected boolean isSlotEnabled(int index) {
        return ((OwoSlotExtension)this.f_97732_.f_38839_.get(index)).owo$getDisabledOverride();
    }

    protected boolean isSlotEnabled(Slot slot) {
        return ((OwoSlotExtension)slot).owo$getDisabledOverride();
    }

    protected SlotComponent slotAsComponent(int index) {
        return new SlotComponent(index);
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        if (!this.invalid) {
            super.m_6305_(matrices, mouseX, mouseY, delta);
            if (this.uiAdapter.enableInspector) {
                matrices.m_85837_(0.0, 0.0, 500.0);
                for (int i = 0; i < this.f_97732_.f_38839_.size(); ++i) {
                    Slot slot = (Slot)this.f_97732_.f_38839_.get(i);
                    if (!slot.m_6659_()) continue;
                    Drawer.drawText(matrices, (Component)Component.m_237113_((String)String.valueOf(i)), this.f_97735_ + slot.f_40220_ + 15, this.f_97736_ + slot.f_40221_ + 9, 0.5f, 38655, Drawer.TextAnchor.BOTTOM_RIGHT);
                    Drawer.drawText(matrices, (Component)Component.m_237113_((String)("(" + slot.m_150661_() + ")")), this.f_97735_ + slot.f_40220_ + 15, this.f_97736_ + slot.f_40221_ + 15, 0.5f, 5767423, Drawer.TextAnchor.BOTTOM_RIGHT);
                }
                matrices.m_85837_(0.0, 0.0, -500.0);
            }
            this.m_7025_(matrices, mouseX, mouseY);
        } else {
            this.m_7379_();
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean bl;
        if (keyCode == 256 && this.m_6913_()) {
            this.m_7379_();
            return true;
        }
        ModComponent modComponent = this.uiAdapter.rootComponent.focusHandler().focused();
        if (modComponent instanceof GreedyInputComponent) {
            GreedyInputComponent inputComponent = (GreedyInputComponent)modComponent;
            bl = inputComponent.onKeyPress(keyCode, scanCode, modifiers);
        } else {
            bl = super.m_7933_(keyCode, scanCode, modifiers);
        }
        return bl;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.uiAdapter.m_7979_(mouseX, mouseY, button, deltaX, deltaY) || super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Nullable
    public GuiEventListener m_7222_() {
        return this.uiAdapter;
    }

    public void m_7861_() {
        if (this.uiAdapter != null) {
            this.uiAdapter.dispose();
        }
        this.f_96541_.f_91068_.m_90926_(false);
        super.m_7861_();
    }

    protected void m_7286_(PoseStack matrices, float delta, int mouseX, int mouseY) {
    }

    public class SlotComponent
    extends BaseComponent {
        protected final Slot slot;
        protected boolean didDraw = false;

        protected SlotComponent(int index) {
            this.slot = BaseOwoHandledScreen.this.f_97732_.m_38853_(index);
        }

        @Override
        public void draw(PoseStack matrices, int mouseX, int mouseY, float partialTicks, float delta) {
            this.didDraw = true;
            int[] scissor = new int[4];
            GL11.glGetIntegerv((int)3088, (int[])scissor);
            ((OwoSlotExtension)this.slot).owo$setScissorArea(PositionedRectangle.of(scissor[0], scissor[1], scissor[2], scissor[3]));
        }

        @Override
        public void update(float delta, int mouseX, int mouseY) {
            super.update(delta, mouseX, mouseY);
            ((OwoSlotExtension)this.slot).owo$setDisabledOverride(!this.didDraw);
            this.didDraw = false;
        }

        @Override
        public void drawTooltip(PoseStack matrices, int mouseX, int mouseY, float partialTicks, float delta) {
            if (!this.slot.m_6657_()) {
                super.drawTooltip(matrices, mouseX, mouseY, partialTicks, delta);
            }
        }

        @Override
        public boolean shouldDrawTooltip(double mouseX, double mouseY) {
            return super.shouldDrawTooltip(mouseX, mouseY);
        }

        @Override
        protected void applyHorizontalContentSizing(Sizing sizing) {
            this.width = 16;
        }

        @Override
        protected void applyVerticalContentSizing(Sizing sizing) {
            this.height = 16;
        }

        @Override
        public void setX(int x) {
            super.setX(x);
            ((SlotAccessor)this.slot).owo$setX(x - BaseOwoHandledScreen.this.f_97735_);
        }

        @Override
        public void setY(int y) {
            super.setY(y);
            ((SlotAccessor)this.slot).owo$setY(y - BaseOwoHandledScreen.this.f_97736_);
        }
    }
}

