/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.mixin;

import com.nyfaria.numismaticoverhaul.currency.CurrencyHelper;
import com.nyfaria.numismaticoverhaul.item.CurrencyItem;
import com.nyfaria.numismaticoverhaul.villagers.data.NumismaticTradeOfferExtensions;
import java.util.Collections;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={MerchantOffer.class})
public class TradeOfferMixin
implements NumismaticTradeOfferExtensions {
    @Shadow
    @Final
    private ItemStack f_45310_;
    private int numismatic$reputation = 0;

    @Override
    public void numismatic$setReputation(int reputation) {
        this.numismatic$reputation = reputation;
    }

    @Override
    public int numismatic$getReputation() {
        return this.numismatic$reputation;
    }

    @Inject(method={"createTag"}, at={@At(value="RETURN")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void saveReputation(CallbackInfoReturnable<CompoundTag> cir, CompoundTag nbt) {
        nbt.m_128405_("Reputation", this.numismatic$reputation);
    }

    @Inject(method={"<init>(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="RETURN")})
    private void loadReputation(CompoundTag nbt, CallbackInfo ci) {
        this.numismatic$reputation = nbt.m_128451_("Reputation");
    }

    @Inject(method={"getCostA"}, at={@At(value="HEAD")}, cancellable=true)
    private void adjustFirstStack(CallbackInfoReturnable<ItemStack> cir) {
        if (this.numismatic$reputation == -69420) {
            return;
        }
        Item item = this.f_45310_.m_41720_();
        if (!(item instanceof CurrencyItem)) {
            return;
        }
        CurrencyItem currencyItem = (CurrencyItem)item;
        long originalValue = currencyItem.getValue(this.f_45310_);
        long adjustedValue = this.numismatic$reputation < 0 ? (long)((double)originalValue + (double)Math.abs(this.numismatic$reputation) * ((double)Math.abs(originalValue) * 0.02)) : (long)Math.max(1.0f, (float)originalValue - (float)Math.abs(originalValue) * ((float)this.numismatic$reputation / ((float)this.numismatic$reputation + 100.0f)));
        adjustedValue = Math.min(adjustedValue, 990000L);
        ItemStack roundedStack = CurrencyHelper.getClosest(adjustedValue);
        if (originalValue != (long)CurrencyHelper.getValue(Collections.singletonList(roundedStack)) && !roundedStack.m_150930_(this.f_45310_.m_41720_())) {
            CurrencyItem.setOriginalValue(roundedStack, originalValue);
        }
        cir.setReturnValue((Object)roundedStack);
    }
}

