/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.currency;

import com.nyfaria.numismaticoverhaul.currency.Currency;
import com.nyfaria.numismaticoverhaul.currency.CurrencyResolver;
import com.nyfaria.numismaticoverhaul.init.ItemInit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CurrencyConverter {
    public static ItemStack[] getAsItemStackArray(long value) {
        ItemStack[] output = new ItemStack[]{null, null, null};
        long[] values = CurrencyResolver.splitValues(value);
        output[2] = new ItemStack((ItemLike)ItemInit.GOLD_COIN.get(), CurrencyConverter.asInt(values[2]));
        output[1] = new ItemStack((ItemLike)ItemInit.SILVER_COIN.get(), CurrencyConverter.asInt(values[1]));
        output[0] = new ItemStack((ItemLike)ItemInit.BRONZE_COIN.get(), CurrencyConverter.asInt(values[0]));
        return output;
    }

    public static List<ItemStack> getAsItemStackList(long value) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        Arrays.stream(CurrencyConverter.getAsItemStackArray(value)).forEach(itemStack -> {
            if (itemStack.m_41613_() != 0) {
                list.add(0, (ItemStack)itemStack);
            }
        });
        return list;
    }

    public static List<ItemStack> getAsItemStackList(long[] values) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < values.length; ++i) {
            if (values[i] <= 0L) continue;
            list.add(0, new ItemStack((ItemLike)Currency.values()[i], CurrencyConverter.asInt(values[i])));
        }
        return list;
    }

    public static int getRequiredCurrencyTypes(long value) {
        return CurrencyConverter.splitAtMaxCount(CurrencyConverter.getAsItemStackList(value)).size();
    }

    public static List<ItemStack> splitAtMaxCount(List<ItemStack> input) {
        ArrayList<ItemStack> output = new ArrayList<ItemStack>();
        for (ItemStack stack : input) {
            if (stack.m_41613_() <= stack.m_41741_()) {
                output.add(stack);
                continue;
            }
            for (int i = 0; i < stack.m_41613_() / stack.m_41741_(); ++i) {
                ItemStack copy = stack.m_41777_();
                copy.m_41764_(stack.m_41741_());
                output.add(copy);
            }
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(stack.m_41613_() % stack.m_41741_());
            output.add(copy);
        }
        return output;
    }

    public static List<ItemStack> getAsValidStacks(long value) {
        return CurrencyConverter.splitAtMaxCount(CurrencyConverter.getAsItemStackList(value));
    }

    public static List<ItemStack> getAsValidStacks(long[] values) {
        return CurrencyConverter.splitAtMaxCount(CurrencyConverter.getAsItemStackList(values));
    }

    public static int asInt(long value) {
        return value > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)value;
    }
}

